/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.utils.audio.wav;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class WAVUtil {
    public static void pcmToWav(String pcmFilename, String weveFilename, long mSampleRate) {
        int mBufferSize = 1024;
        long longSampleRate = mSampleRate;
        int channels = 1;
        long byteRate = 16L * mSampleRate * (long)channels / 8L;
        byte[] data = new byte[mBufferSize];
        try {
            FileInputStream in = new FileInputStream(pcmFilename);
            FileOutputStream out = new FileOutputStream(weveFilename);
            long totalAudioLen = in.getChannel().size();
            long totalDataLen = totalAudioLen + 36L;
            WAVUtil.writeWaveFileHeader(out, totalAudioLen, totalDataLen, longSampleRate, channels, byteRate);
            while (in.read(data) != -1) {
                out.write(data);
            }
            in.close();
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeWaveFileHeader(FileOutputStream out, long totalAudioLen, long totalDataLen, long longSampleRate, int channels, long byteRate) throws IOException {
        byte[] header = new byte[]{82, 73, 70, 70, (byte)(totalDataLen & 0xFFL), (byte)(totalDataLen >> 8 & 0xFFL), (byte)(totalDataLen >> 16 & 0xFFL), (byte)(totalDataLen >> 24 & 0xFFL), 87, 65, 86, 69, 102, 109, 116, 32, 16, 0, 0, 0, 1, 0, (byte)channels, 0, (byte)(longSampleRate & 0xFFL), (byte)(longSampleRate >> 8 & 0xFFL), (byte)(longSampleRate >> 16 & 0xFFL), (byte)(longSampleRate >> 24 & 0xFFL), (byte)(byteRate & 0xFFL), (byte)(byteRate >> 8 & 0xFFL), (byte)(byteRate >> 16 & 0xFFL), (byte)(byteRate >> 24 & 0xFFL), 4, 0, 16, 0, 100, 97, 116, 97, (byte)(totalAudioLen & 0xFFL), (byte)(totalAudioLen >> 8 & 0xFFL), (byte)(totalAudioLen >> 16 & 0xFFL), (byte)(totalAudioLen >> 24 & 0xFFL)};
        out.write(header, 0, 44);
    }
}

