/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.utils.maven;

import com.litongjava.utils.maven.Dependency;
import com.litongjava.utils.maven.MavenInstall;
import com.litongjava.utils.maven.MavenSimpleFileVisitor;
import com.litongjava.utils.string.StringUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class MavenUtils {
    public static List<Dependency> parse(List<String> jars, String repodir) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (String jar : jars) {
            MavenUtils.getDependency(jar, "D:\\dev_workspace\\java\\litong_prject\\maven-util\\target\\classes\\jar\\");
        }
        return dependencies;
    }

    public static Dependency getDependency(String jarAbsolutePath, String repodir) {
        File jarFile = new File(jarAbsolutePath);
        String jarPath = jarFile.getAbsolutePath();
        String all = StringUtils.removePrefix(jarPath, repodir);
        String[] splits = StringUtils.splitPath(all);
        String jarNmae = splits[splits.length - 1];
        String version = MavenUtils.getVersion(jarNmae);
        String artifactid = MavenUtils.getArtifactId(jarNmae);
        System.out.println(all);
        all = StringUtils.removeSuffix(all, "\\" + artifactid + "\\" + version + "\\" + jarNmae);
        String groupid = all.replace("\\", ".");
        System.out.println(all);
        Dependency dependency = new Dependency();
        dependency.setArtifactId(artifactid);
        dependency.setVersion(version);
        dependency.setGroupId(groupid);
        return dependency;
    }

    public static String getArtifactId(String jarName) {
        String[] strings = jarName.split("-");
        return MavenUtils.getArtifactId(strings);
    }

    public static String getArtifactId(String[] strings) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < strings.length - 2; ++i) {
            stringBuffer.append(strings[i]).append('-');
        }
        stringBuffer.append(strings[strings.length - 2]);
        return stringBuffer.toString();
    }

    public static String getVersion(String jar) {
        String[] strings = jar.split("-");
        return MavenUtils.getVersion(strings);
    }

    public static String getVersion(String[] strings) {
        return StringUtils.removeSuffix(strings[strings.length - 1], ".jar");
    }

    public void deleteBadJarInMavenLoacalRepository(String dirname) {
        Path dir = Paths.get(dirname, new String[0]);
        try {
            Files.walkFileTree(dir, new MavenSimpleFileVisitor());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String install(String mvnPath, String jarPath, String localMavenPath) {
        return MavenInstall.install(mvnPath, jarPath, localMavenPath);
    }

    public static List<Dependency> recursiveGetFile(File folderFile, List<Dependency> listDependencies, String localMavenPath) {
        File[] listFiles;
        for (File file : listFiles = folderFile.listFiles()) {
            String filename = file.getName();
            if (file.isDirectory()) {
                MavenUtils.recursiveGetFile(file, listDependencies, localMavenPath);
                continue;
            }
            if (!filename.endsWith(".jar") || filename.endsWith("sources.jar")) continue;
            listDependencies.add(MavenUtils.getDependency(file, localMavenPath));
        }
        return listDependencies;
    }

    public static Dependency getDependency(File file, String localMavenPath) {
        Dependency e = new Dependency();
        String name = file.getName();
        String depencyString = file.getAbsolutePath().replace(localMavenPath, "").replace(name, "");
        String[] split = null;
        split = File.separatorChar == '\\' ? depencyString.split("\\\\") : depencyString.split("/");
        e.setVersion(split[split.length - 1]);
        e.setArtifactId(split[split.length - 2]);
        StringBuffer gruopId = new StringBuffer();
        for (int i = 1; i < split.length - 3; ++i) {
            gruopId.append(split[i]).append(".");
        }
        gruopId.append(split[split.length - 3]);
        e.setGroupId(gruopId.toString());
        return e;
    }
}

