/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.utils.exec;

import com.litongjava.utils.sytstem.RuntimeUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmdUtils {
    private static final Logger log = LoggerFactory.getLogger(CmdUtils.class);

    public static String execCmd(String command) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
        try {
            CommandLine commandline = CommandLine.parse((String)command);
            DefaultExecutor exec = new DefaultExecutor();
            exec.setExitValues(null);
            ExecuteWatchdog watchdog = new ExecuteWatchdog(60000L);
            exec.setWatchdog(watchdog);
            PumpStreamHandler streamHandler = new PumpStreamHandler((OutputStream)outputStream, (OutputStream)errorStream);
            exec.setStreamHandler((ExecuteStreamHandler)streamHandler);
            exec.execute(commandline);
            String osType = RuntimeUtils.getOsType();
            String out = null;
            String error = null;
            if (osType.contains("Windows 10") || osType.contains("Windows")) {
                log.info(osType);
                out = outputStream.toString("GBK");
                error = errorStream.toString("GBK");
            } else {
                log.info(osType);
                out = outputStream.toString();
                error = errorStream.toString();
            }
            return out + error;
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public static void main(String[] args) {
        String command = "ping 192.168.0.10";
        String result = CmdUtils.execCmd(command);
        System.out.println(result);
    }
}

