/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.utils.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ConfigUtils {
    private static String configFilePath = null;
    private static Properties prop = null;
    private static InputStream ins = null;

    public static String getValue(String key) {
        return prop.getProperty(key);
    }

    public static void put(String key, String value) {
        prop.put(key, value);
        ConfigUtils.save();
    }

    public static void save() {
        URL url = ConfigUtils.class.getClassLoader().getResource(configFilePath);
        File file = new File(url.getFile());
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            prop.store(fileOutputStream, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Properties getProperties() {
        return prop;
    }

    public static String getConfigFile() {
        return configFilePath;
    }

    public static void main(String[] args) {
        Properties prop = ConfigUtils.getProperties();
        Set<Map.Entry<Object, Object>> entrySet = prop.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            System.out.println("" + entry.getKey() + "=" + entry.getValue());
        }
    }

    static {
        Properties modeProperties = new Properties();
        InputStream resourceAsStream = ConfigUtils.class.getResourceAsStream("/mode.properties");
        try {
            modeProperties.load(resourceAsStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String mode = modeProperties.getProperty("mode");
        configFilePath = "config-" + mode + ".properties";
        ins = ConfigUtils.class.getClassLoader().getResourceAsStream(configFilePath);
        InputStreamReader insReader = null;
        try {
            insReader = new InputStreamReader(ins, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        prop = new Properties();
        try {
            prop.load(insReader);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

