/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.utils.apache.commons.httpclient;

import com.alibaba.fastjson.JSON;
import com.litongjava.utils.string.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;

public class CommonsHttpClientUtils {
    private static HttpClient httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
    public static boolean debug;

    public static String get(String url) {
        String s = CommonsHttpClientUtils.get(url, null);
        return s;
    }

    public static String get(String url, Map<String, String> params) {
        GetMethod getMethod = null;
        String retval = null;
        if (params == null) {
            getMethod = new GetMethod(url);
        } else {
            url = CommonsHttpClientUtils.appendURL(url, params);
            if (debug) {
                System.out.println(url);
            }
            getMethod = new GetMethod(url);
        }
        retval = CommonsHttpClientUtils.executeMethod((HttpMethod)getMethod);
        return retval;
    }

    public static String appendURL(String url, Map<String, String> params) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Map.Entry<String, String> e : params.entrySet()) {
            stringBuffer.append("&");
            try {
                stringBuffer.append(e.getKey() + "=" + URLEncoder.encode(e.getValue(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e1) {
                e1.printStackTrace();
            }
        }
        url = url.contains("?") ? url + stringBuffer.toString() : url + "?" + stringBuffer.toString();
        return url;
    }

    private static String executeMethod(HttpMethod method) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            httpClient.executeMethod(method);
            InputStream inputStream = method.getResponseBodyAsStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
            String str = null;
            while ((str = br.readLine()) != null) {
                stringBuffer.append(str);
            }
        }
        catch (IOException e) {
            try {
                System.err.println(method.getURI().toString());
            }
            catch (URIException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
        return stringBuffer.toString();
    }

    public static String post(String url, Map<String, String> header, Map<String, String> data) {
        PostMethod postMethod = new PostMethod(url);
        postMethod.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        if (header != null) {
            for (Map.Entry<String, String> e : header.entrySet()) {
                postMethod.setRequestHeader(e.getKey(), e.getValue());
            }
        }
        if (data != null) {
            for (Map.Entry<String, String> e : data.entrySet()) {
                if (StringUtils.isEmpty(e.getValue())) continue;
                postMethod.setParameter(e.getKey(), e.getValue());
            }
        }
        String retval = CommonsHttpClientUtils.executeMethod((HttpMethod)postMethod);
        postMethod.releaseConnection();
        return retval;
    }

    public static String postJSON(String url, Map<String, String> data, String encoding) {
        String jsonString = JSON.toJSONString(data);
        String retval = CommonsHttpClientUtils.postJSON(url, jsonString, encoding);
        return retval;
    }

    public static String postJSON(String url, String jsonString, String encoding) {
        PostMethod postMethod = new PostMethod(url);
        try {
            StringRequestEntity requestEntity = new StringRequestEntity(jsonString, "application/json", encoding);
            postMethod.setRequestEntity((RequestEntity)requestEntity);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String retval = CommonsHttpClientUtils.executeMethod((HttpMethod)postMethod);
        return retval;
    }

    static {
        httpClient.getParams().setParameter("http.protocol.allow-circular-redirects", (Object)true);
        debug = false;
    }
}

