/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.utils.exec;

import com.litongjava.utils.sytstem.OsTypeUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonsExecUtils {
    private static final Logger log = LoggerFactory.getLogger(CommonsExecUtils.class);

    public static String exec(String command, long timeout) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
        try {
            CommandLine commandline = CommandLine.parse((String)command);
            DefaultExecutor exec = new DefaultExecutor();
            exec.setExitValues(null);
            ExecuteWatchdog watchdog = new ExecuteWatchdog(timeout);
            exec.setWatchdog(watchdog);
            PumpStreamHandler streamHandler = new PumpStreamHandler((OutputStream)outputStream, (OutputStream)errorStream);
            exec.setStreamHandler((ExecuteStreamHandler)streamHandler);
            exec.execute(commandline);
            String osType = OsTypeUtils.getOsType();
            log.info(osType);
            String out = null;
            String error = null;
            if (osType.contains("Windows 10") || osType.contains("Windows")) {
                out = outputStream.toString("GBK");
                error = errorStream.toString("GBK");
            } else {
                out = outputStream.toString();
                error = errorStream.toString();
            }
            return out + error;
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public static String exec(String command) {
        return CommonsExecUtils.exec(command, 3600000L);
    }
}

