/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.utils.ibot.robot;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DOMXMLUtil {
    private static DocumentBuilder builer = null;
    private static Transformer transformer = null;

    private static void initDocumentBuilder() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        try {
            builer = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public static void initRransformer() {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
    }

    public static Map<String, String> parseXmlToMap(String fromXML) {
        return DOMXMLUtil.parseDocumentToMap(DOMXMLUtil.parseXMLToDocument(fromXML));
    }

    private static Map<String, String> parseDocumentToMap(Document document) {
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        Element rootElement = document.getDocumentElement();
        NodeList nodeList = rootElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String nodeName = node.getNodeName();
            String nodeText = node.getTextContent();
            map.put(nodeName, nodeText);
        }
        return map;
    }

    public static Document parseXMLToDocument(String xml) {
        try (StringReader sr = null;){
            sr = new StringReader(xml);
            Document document = builer.parse(new InputSource(sr));
            return document;
        }
        return null;
    }

    public static Document newDocument() {
        return builer.newDocument();
    }

    public static void addToRoot(String tagName, String content, Document document) {
        Element rootElement = document.getDocumentElement();
        Element ele = document.createElement(tagName);
        rootElement.appendChild(ele);
        ele.setTextContent(content);
    }

    public static String domToXML(Document document) {
        document.setXmlStandalone(true);
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        DOMSource domSource = new DOMSource(document);
        try {
            transformer.transform(domSource, streamResult);
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return stringWriter.toString();
    }

    static {
        DOMXMLUtil.initDocumentBuilder();
        DOMXMLUtil.initRransformer();
    }
}

