/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.utils.pinyin;

import com.litongjava.utils.pinyin.PinyinBean;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pinyin4j.PinyinHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinyinUtils {
    private static final Logger log = LoggerFactory.getLogger(PinyinUtils.class);
    private String hanyuRegex = "[\\u4E00-\\u9FA5]+";
    private String numRegex = "[0-9]";

    public String[] toPinyin(char c) {
        String[] array = PinyinHelper.toHanyuPinyinStringArray((char)c);
        return array;
    }

    public List<String[]> toPinin(String input) {
        char[] array;
        ArrayList<String[]> list = new ArrayList<String[]>();
        for (char c : array = input.toCharArray()) {
            String[] pinYinArray = PinyinHelper.toHanyuPinyinStringArray((char)c);
            list.add(pinYinArray);
        }
        return list;
    }

    public String toPinyinString(String input) {
        char[] array;
        StringBuffer stringBuffer = new StringBuffer();
        for (char c : array = input.toCharArray()) {
            String[] pinyinArray = PinyinHelper.toHanyuPinyinStringArray((char)c);
            if (pinyinArray.length < 1) {
                return null;
            }
            String last = pinyinArray[0].substring(pinyinArray[0].length() - 1);
            if (last.matches(this.hanyuRegex)) {
                String pinyin = pinyinArray[0].substring(0, pinyinArray[0].length() - 1);
                stringBuffer.append(pinyin);
                continue;
            }
            stringBuffer.append(pinyinArray[0]);
        }
        return stringBuffer.toString();
    }

    public boolean isHanzi(String input) {
        for (int i = 0; i < input.length(); ++i) {
            String current = input.substring(i, i + 1);
            if (!current.matches(this.hanyuRegex)) continue;
            return true;
        }
        return false;
    }

    public List<PinyinBean> toListPinyinBean(String string) {
        char[] chars;
        ArrayList<PinyinBean> pinyinList = new ArrayList<PinyinBean>();
        for (char c : chars = string.toCharArray()) {
            String[] pinyinArray = PinyinHelper.toHanyuPinyinStringArray((char)c);
            if (pinyinArray == null) {
                log.info("string:" + string);
                log.info("\u8fd4\u56denull");
                return null;
            }
            String last = pinyinArray[0].substring(pinyinArray[0].length() - 1);
            if (last.matches(this.numRegex)) {
                String pinyin = pinyinArray[0].substring(0, pinyinArray[0].length() - 1);
                pinyinList.add(new PinyinBean(c, pinyin));
                continue;
            }
            pinyinList.add(new PinyinBean(c, pinyinArray[0]));
        }
        return pinyinList;
    }
}

