/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.utils.excel;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class PoiExcelUtils {
    public static List<Map<String, Object>> readExcel(String filepath, int index) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        Workbook workbook = null;
        try {
            int i;
            workbook = WorkbookFactory.create((InputStream)new FileInputStream(filepath));
            Sheet sheet = workbook.getSheetAt(index);
            Row row = sheet.getRow(0);
            ArrayList<String> keys = new ArrayList<String>();
            for (i = 0; i < row.getLastCellNum(); ++i) {
                Cell cell = row.getCell(i);
                keys.add(String.valueOf(PoiExcelUtils.getValue(cell)));
            }
            for (i = 1; i <= sheet.getLastRowNum(); ++i) {
                Row currentRow = sheet.getRow(i);
                LinkedHashMap map = new LinkedHashMap();
                for (int j = 0; j < currentRow.getLastCellNum(); ++j) {
                    map.put(keys.get(j), PoiExcelUtils.getValue(currentRow.getCell(j)));
                }
                mapList.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("excel\u89e3\u6790\u51fa\u9519");
        }
        finally {
            try {
                if (workbook != null) {
                    workbook.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return mapList;
    }

    private static Object getValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        if (cell.getCellTypeEnum() == CellType.BOOLEAN) {
            return cell.getBooleanCellValue();
        }
        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
            return cell.getNumericCellValue();
        }
        return String.valueOf(cell.getStringCellValue());
    }
}

