/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.utils.kod;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.litongjava.utils.digest.SHA1Utils;
import com.litongjava.utils.httpclient.HttpClientUtils;
import com.litongjava.utils.httpclient.HttpUploadUtils;
import com.litongjava.utils.io.IOUtils;
import com.litongjava.utils.kod.AccessTokenCache;
import com.litongjava.utils.kod.SidCache;
import com.litongjava.utils.url.UrlUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KodUtils {
    private static final Logger log = LoggerFactory.getLogger(KodUtils.class);
    private static Map<String, AccessTokenCache> accessTokenMap = new HashMap<String, AccessTokenCache>();
    private static Map<String, SidCache> sidCacheMap = new HashMap<String, SidCache>();

    public static Map<String, SidCache> getSidCacheMap() {
        return sidCacheMap;
    }

    public static String getAccessToken(String serverURL, String username, String apiLoginTonken) {
        String retval = null;
        AccessTokenCache cache = accessTokenMap.get(serverURL);
        if (cache == null || cache.isExpire()) {
            String loginToken = KodUtils.getLoginToken(username, apiLoginTonken);
            StringBuffer link = UrlUtils.append(serverURL, "?user/accessToken");
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("link", link.toString());
            params.put("login_token", loginToken);
            serverURL = UrlUtils.append(serverURL, "?user/loginSubmit").toString();
            String jsonString = HttpClientUtils.get(serverURL, params);
            JSONObject jsonObject = JSON.parseObject((String)jsonString);
            Boolean code = jsonObject.getBoolean("code");
            retval = code != false ? jsonObject.getString("data") : jsonString;
            cache = new AccessTokenCache();
            cache.setAccessToken(retval);
            cache.setExpireTime(System.currentTimeMillis() + 86400000L);
        } else {
            retval = cache.getAccessToken();
        }
        return retval;
    }

    public static String getLoginToken(String username, String apiLoginTonken) {
        byte[] userBytes = username.getBytes();
        String encodeBase64String = Base64.encodeBase64String((byte[])userBytes);
        String md5Hex = DigestUtils.md5Hex((String)(username + apiLoginTonken));
        String retval = encodeBase64String + '|' + md5Hex;
        return retval;
    }

    public static String pathList(String serverURL, String username, String apiLoginTonken, String path) {
        String retval = null;
        String accessToken = KodUtils.getAccessToken(serverURL, username, apiLoginTonken);
        StringBuffer append = UrlUtils.append(serverURL, "?explorer/pathList");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accessToken", accessToken);
        params.put("path", path);
        retval = HttpClientUtils.get(append.toString(), params);
        return retval;
    }

    public static String upload(String serverURL, String username, String apiLoginToken, String uploadTo, FileInputStream fis, String filePath) {
        String accessToken = KodUtils.getAccessToken(serverURL, username, apiLoginToken);
        StringBuffer append = UrlUtils.append(serverURL, "?explorer/fileUpload");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accessToken", accessToken);
        params.put("upload_to", uploadTo);
        StringBuffer queryParams = HttpClientUtils.buildHttpQueryParams(params);
        String url = append.toString() + queryParams.toString();
        StringBuilder stringBuilder = HttpUploadUtils.uploadFile(url, fis, "file", filePath);
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String upload(String serverURL, String username, String apiLoginToken, String uploadTo, File file) {
        String string;
        String path = file.getAbsolutePath();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            string = KodUtils.upload(serverURL, username, apiLoginToken, uploadTo, fis, path);
        }
        catch (FileNotFoundException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
            IOUtils.closeQuietly(fis);
            return null;
        }
        IOUtils.closeQuietly(fis);
        return string;
    }

    public static String upload(String serverURL, String username, String apiLoginToken, String uploadTo, String localFilepath) {
        File localFile = new File(localFilepath);
        String upload = KodUtils.upload(serverURL, username, apiLoginToken, uploadTo, localFile);
        return upload;
    }

    public static String setUserShare(String serverURL, String username, String apiLoginToken, String fileType, String remoteFilePath) {
        String accessToken = KodUtils.getAccessToken(serverURL, username, apiLoginToken);
        String name = FilenameUtils.getName((String)remoteFilePath);
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuffer append = UrlUtils.append(serverURL, "?userShare/set");
        params.put("accessToken", accessToken);
        params.put("type", fileType);
        params.put("path", remoteFilePath);
        params.put("name", name);
        String retval = HttpClientUtils.post(append.toString(), null, params);
        return retval;
    }

    public static String getUserShare(String serverURL, String username, String apiLoginTonken) {
        String retval = null;
        StringBuffer append = UrlUtils.append(serverURL, "?userShare/get");
        String accessToken = KodUtils.getAccessToken(serverURL, username, apiLoginTonken);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accessToken", accessToken);
        retval = HttpClientUtils.get(append.toString(), params);
        return retval;
    }

    public static String uploadAndShare(String serverURL, String username, String apiLoginTonken, String uploadTo, File localFile) {
        String sha1 = SHA1Utils.getSha1(localFile);
        SidCache sidCache = sidCacheMap.get(sha1);
        if (sidCache != null) {
            JSONObject dataObject;
            Boolean isReadable;
            String pathInfoResult = KodUtils.pathInfo(serverURL, username, apiLoginTonken, "file", sidCache.getRemoteAbsPath());
            log.info("\u83b7\u53d6\u5230\u7684\u8fdc\u7a0b\u6587\u4ef6\u5c5e\u6027:" + pathInfoResult);
            JSONObject jsonObject = JSON.parseObject((String)pathInfoResult);
            boolean code = jsonObject.getBooleanValue("code");
            if (code && (isReadable = (dataObject = jsonObject.getJSONObject("data")).getBoolean("isReadable")).booleanValue()) {
                log.info("\u8fdc\u7a0b\u6587\u4ef6\u5b58\u5728,\u8fd4\u56de\u7f13\u5b58\u7684\u4e0a\u4f20\u5730\u5740");
                String downloadURL = KodUtils.getDownloadURL(serverURL, sidCache.getSid());
                return downloadURL;
            }
            log.info("\u8fdc\u7a0b\u8fdc\u7a0b\u5df2\u7ecf\u4e0d\u5b58\u5728,\u91cd\u65b0\u4e0a\u4f20");
        }
        String uploadReturnJSONString = KodUtils.upload(serverURL, username, apiLoginTonken, uploadTo, localFile);
        Boolean code = false;
        JSONObject jsonObject = null;
        try {
            jsonObject = JSON.parseObject((String)uploadReturnJSONString);
            code = jsonObject.getBoolean("code");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!code.booleanValue()) {
            System.out.println("KodUtil.uploadAndShare()");
            System.out.println("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25:" + uploadReturnJSONString);
            System.out.println("\u5f00\u59cb\u521b\u5efa\u6587\u4ef6\u5939");
            String mkdirResult = KodUtils.mkdir(serverURL, username, apiLoginTonken, uploadTo);
            uploadReturnJSONString = KodUtils.upload(serverURL, username, apiLoginTonken, uploadTo, localFile);
            try {
                jsonObject = JSON.parseObject((String)uploadReturnJSONString);
                code = jsonObject.getBoolean("code");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String fullPath = null;
        if (code.booleanValue()) {
            fullPath = jsonObject.getString("info");
        } else {
            System.out.println("KodUtil.uploadAndShare()");
            System.out.println("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25:" + uploadReturnJSONString);
        }
        String fileType = KodUtils.getFileType(localFile);
        String userSharRetrunJSONstring = KodUtils.setUserShare(serverURL, username, apiLoginTonken, fileType, fullPath);
        try {
            jsonObject = JSON.parseObject((String)userSharRetrunJSONstring);
            code = jsonObject.getBoolean("code");
        }
        catch (Exception e) {
            System.out.println("\u89e3\u6790\u9519\u8bef:" + userSharRetrunJSONstring);
            e.printStackTrace();
        }
        String sid = null;
        if (code.booleanValue()) {
            sid = jsonObject.getJSONObject("data").getString("sid");
            String remoteFileFullPath = jsonObject.getJSONObject("data").getString("path");
            sidCache = new SidCache(sha1, localFile.getAbsolutePath().toString(), sid, remoteFileFullPath);
            sidCacheMap.put(sha1, sidCache);
        } else {
            System.out.println("\u6587\u4ef6\u5206\u4eab\u5931\u8d25:" + userSharRetrunJSONstring);
        }
        String downloadURL = KodUtils.getDownloadURL(serverURL, sid);
        return downloadURL;
    }

    public static String mkdir(String serverURL, String username, String apiLoginTonken, String uploadTo) {
        String accessToken = KodUtils.getAccessToken(serverURL, username, apiLoginTonken);
        StringBuffer url = UrlUtils.append(serverURL, "?explorer/mkdir");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accessToken", accessToken);
        params.put("path", uploadTo);
        String post = HttpClientUtils.post(url.toString(), null, params);
        JSONObject jsonObject = JSON.parseObject((String)post);
        Boolean code = jsonObject.getBoolean("code");
        if (!code.booleanValue()) {
            System.out.println("KodUtil.mkdir()");
            System.out.println("\u6587\u4ef6\u5939\u521b\u5efa\u5931\u8d25:" + post);
        }
        return post;
    }

    public static String getDownloadURL(String serverURL, String sid) {
        StringBuffer append = UrlUtils.append(serverURL, "index.php?share/file&user=1&sid=" + sid);
        return append.toString();
    }

    private static String getFileType(File localFile) {
        if (localFile.isFile()) {
            return "file";
        }
        if (localFile.isDirectory()) {
            return "folder";
        }
        return null;
    }

    public static String pathInfo(String serverURL, String username, String apiLoginTonken, String fileType, String absPath) {
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"type", (Object)fileType);
        jsonObject.put((Object)"path", (Object)absPath);
        jsonArray.add((Object)jsonObject);
        return KodUtils.pathInfo(serverURL, username, apiLoginTonken, jsonArray);
    }

    private static String pathInfo(String serverURL, String username, String apiLoginTonken, JSONArray jsonArray) {
        String accessToken = KodUtils.getAccessToken(serverURL, username, apiLoginTonken);
        StringBuffer url = UrlUtils.append(serverURL, "?explorer/pathInfo");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accessToken", accessToken);
        params.put("dataArr", jsonArray.toJSONString(new JSONWriter.Feature[0]));
        String post = HttpClientUtils.post(url.toString(), null, params);
        JSONObject jsonObject = JSON.parseObject((String)post);
        Boolean code = jsonObject.getBoolean("code");
        if (!code.booleanValue()) {
            System.out.println("KodUtil.pathInfo()\u83b7\u53d6\u6587\u4ef6\u5c5e\u6027\u5931\u8d25:" + post);
        }
        return post;
    }
}

