/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.utils.okhttp;

import java.util.Map;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpUtils {
    private static final Logger logger = LoggerFactory.getLogger(OkHttpUtils.class);

    public static StringBuffer getQueryString(String url, Map<String, String> queries) {
        StringBuffer sb = new StringBuffer(url);
        if (queries != null && queries.keySet().size() > 0) {
            boolean firstFlag = true;
            for (Map.Entry<String, String> entry : queries.entrySet()) {
                if (firstFlag) {
                    sb.append("?" + entry.getKey() + "=" + entry.getValue());
                    firstFlag = false;
                    continue;
                }
                sb.append("&" + entry.getKey() + "=" + entry.getValue());
            }
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String execNewCall(OkHttpClient okHttpClient, Request request) {
        try (Response response = null;){
            response = okHttpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                String string = response.body().string();
                return string;
            }
        }
        return "";
    }

    public static String get(OkHttpClient client, String url, Map<String, String> queries) {
        StringBuffer sb = OkHttpUtils.getQueryString(url, queries);
        Request request = new Request.Builder().url(sb.toString()).build();
        return OkHttpUtils.execNewCall(client, request);
    }

    public static String postFormParams(OkHttpClient client, String url, Map<String, String> params) {
        FormBody.Builder builder = new FormBody.Builder();
        if (params != null && params.keySet().size() > 0) {
            for (String key : params.keySet()) {
                builder.add(key, params.get(key));
            }
        }
        Request request = new Request.Builder().url(url).post((RequestBody)builder.build()).build();
        return OkHttpUtils.execNewCall(client, request);
    }

    public static String postJsonParams(OkHttpClient client, String url, String jsonParams) {
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonParams);
        Request request = new Request.Builder().url(url).post(requestBody).build();
        return OkHttpUtils.execNewCall(client, request);
    }

    public static String postXmlParams(OkHttpClient client, String url, String xml) {
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/xml; charset=utf-8"), (String)xml);
        Request request = new Request.Builder().url(url).post(requestBody).build();
        return OkHttpUtils.execNewCall(client, request);
    }
}

