/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.utils.projectvariable;

import com.litongjava.utils.json.fastjson.FastJsonSerialiable;
import com.litongjava.utils.projectvariable.NameAndMode;
import com.litongjava.utils.projectvariable.ProjectVariable;
import com.litongjava.utils.projectvariable.ProjectVariableInit;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectVariableUtil {
    private static final Logger log = LoggerFactory.getLogger(ProjectVariableUtil.class);
    private static Map<String, ProjectVariable> parameters = new TreeMap<String, ProjectVariable>();
    private static String configFileName = null;
    public static String name = NameAndMode.map.get(NameAndMode.name);
    public static String mode;

    public static void init(ProjectVariableInit pvi) {
        pvi.initValue();
        ProjectVariableUtil.store();
    }

    public static boolean isEmpty(Object str) {
        return str == null || "".equals(str);
    }

    public static boolean isDev() {
        return parameters.get("project.mode").getValue().equals("dev");
    }

    public static String getValue(String key) {
        String value = parameters.get(key).getValue();
        return value;
    }

    public static void setValue(ProjectVariable variable, boolean isSave) {
        parameters.put(variable.getKey(), variable);
        if (isSave) {
            ProjectVariableUtil.store();
        }
    }

    public static void add(String key, String commnet, String value, boolean isReadOnly, boolean isSave) {
        ProjectVariable variable = parameters.get(key);
        if (isSave) {
            variable = new ProjectVariable();
            variable.setKey(key);
            variable.setComment(commnet);
            variable.setValue(value);
            variable.setReadOnly(isReadOnly);
            ProjectVariableUtil.setValue(variable, isSave);
        } else if (variable == null) {
            variable = new ProjectVariable();
            variable.setKey(key);
            variable.setComment(commnet);
            variable.setValue(value);
            variable.setReadOnly(isReadOnly);
            ProjectVariableUtil.setValue(variable, isSave);
        }
    }

    public static String setValue(String key, String value) {
        ProjectVariable projectVariable = parameters.get(key);
        String retval = null;
        if (projectVariable != null) {
            projectVariable.setValue(value);
            retval = "successed";
        } else {
            projectVariable = new ProjectVariable();
            projectVariable.setKey(key);
            projectVariable.setValue(value);
            parameters.put(key, projectVariable);
            retval = "craeted";
        }
        ProjectVariableUtil.store();
        return retval;
    }

    public static Map<String, ProjectVariable> getParameters() {
        return parameters;
    }

    public static void store() {
        try {
            FastJsonSerialiable.serilizableForMap(parameters, configFileName);
        }
        catch (IOException e) {
            log.info("\u4fdd\u5b58json\u914d\u7f6e\u6587\u4ef6\u5931\u8d25");
            e.printStackTrace();
        }
    }

    public static int size() {
        return parameters.size();
    }

    static {
        if (ProjectVariableUtil.isEmpty(name)) {
            name = "";
        }
        if (ProjectVariableUtil.isEmpty(mode = NameAndMode.map.get(NameAndMode.mode))) {
            mode = "";
        }
        configFileName = "project-variable-" + name + "-" + mode + ".json";
        File configFile = new File(configFileName);
        log.info("\u5de5\u7a0b\u53d8\u91cf\u914d\u7f6e\u6587\u4ef6\u5168\u8def\u5f84:" + configFile.getAbsolutePath());
        boolean exists = configFile.exists();
        try {
            if (exists) {
                parameters = FastJsonSerialiable.deserilizableForMapFromFile(configFileName, String.class, ProjectVariable.class);
            }
        }
        catch (IOException e) {
            log.info("\u8bfb\u53d6json\u914d\u7f6e\u6587\u4ef6\u5931\u8d25");
            e.printStackTrace();
        }
        ProjectVariableUtil.add(NameAndMode.name, "\u5de5\u7a0b\u540d\u5b57", name, true, false);
        ProjectVariableUtil.add(NameAndMode.mode, "\u5de5\u7a0b\u7684\u5f00\u53d1\u6a21\u5f0f", mode, true, false);
    }
}

