/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.utils.serializable;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializableUtils {
    private static final Logger log = LoggerFactory.getLogger(SerializableUtils.class);
    private static String configPath = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeToFile(Object obj, String path) {
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new FileOutputStream(configPath + File.separator + path));
            out.writeObject(obj);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T readFromFile(Class<T> clazz, String path) {
        Object t = null;
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new FileInputStream(configPath + File.separator + path));
            t = in.readObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return (T)t;
    }

    static {
        URL url = SerializableUtils.class.getClassLoader().getResource("");
        configPath = url.getFile() + File.separator + "config";
        File file = new File(configPath);
        if (!file.exists()) {
            log.info("\u521b\u5efaconfig\u6587\u4ef6\u5939:" + configPath);
            file.mkdirs();
        }
    }
}

