/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.utils.table;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class TableUtils {
    public static Map<String, String> javaProperty2SqlColumnMap = new HashMap<String, String>();

    public static String createTable(Class<?> clazz, String tableName) throws IOException {
        Field[] fields = null;
        fields = clazz.getDeclaredFields();
        String param = null;
        String column = null;
        StringBuilder sb = null;
        sb = new StringBuilder(50);
        if (tableName == null || tableName.equals("")) {
            tableName = clazz.getName();
            tableName = tableName.substring(tableName.lastIndexOf(".") + 1);
        }
        sb.append("create table ").append(tableName).append(" ( \r\n");
        System.out.println(tableName);
        boolean firstId = true;
        for (Field f : fields) {
            column = f.getName();
            if (column.equals("serialVersionUID")) continue;
            param = f.getType().getSimpleName();
            sb.append(column);
            sb.append(" ").append(javaProperty2SqlColumnMap.get(param)).append(" ");
            if (firstId) {
                sb.append(" PRIMARY KEY ");
                firstId = false;
            }
            Annotation[] allAnnotations = f.getAnnotations();
            sb.append(",\n ");
        }
        String sql = null;
        sql = sb.toString();
        int lastIndex = sql.lastIndexOf(",");
        sql = sql.substring(0, lastIndex) + sql.substring(lastIndex + 1);
        sql = sql.substring(0, sql.length() - 1) + " )ENGINE =INNODB DEFAULT  CHARSET= utf8;\r\n";
        System.out.println("sql :" + sql);
        return sql;
    }

    static {
        javaProperty2SqlColumnMap.put("Integer", "INTEGER");
        javaProperty2SqlColumnMap.put("Short", "tinyint");
        javaProperty2SqlColumnMap.put("Long", "bigint");
        javaProperty2SqlColumnMap.put("BigDecimal", "decimal(19,2)");
        javaProperty2SqlColumnMap.put("Double", "double precision not null");
        javaProperty2SqlColumnMap.put("Float", "float");
        javaProperty2SqlColumnMap.put("Boolean", "bit");
        javaProperty2SqlColumnMap.put("Timestamp", "datetime");
        javaProperty2SqlColumnMap.put("String", "VARCHAR(255)");
    }
}

