/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.utils.video;

import com.coremedia.iso.IsoFile;
import com.coremedia.iso.boxes.MovieBox;
import com.coremedia.iso.boxes.MovieHeaderBox;
import com.litongjava.utils.audio.AudioUtils;
import java.io.IOException;

public class VideoUtils {
    public static long getMp4Duration(String videoPath) throws IOException {
        IsoFile isoFile = new IsoFile(videoPath);
        MovieBox movieBox = isoFile.getMovieBox();
        MovieHeaderBox movieHeaderBox = movieBox.getMovieHeaderBox();
        long duration = movieHeaderBox.getDuration();
        long timescale = movieHeaderBox.getTimescale();
        isoFile.close();
        long lengthInSeconds = duration / timescale;
        return lengthInSeconds;
    }

    public static long getDuration(String filePath) throws IOException {
        String format = VideoUtils.getVideoFormat(filePath);
        long result = 0L;
        if ("wav".equals(format)) {
            result = AudioUtils.getDuration(filePath).intValue();
        } else if ("mp3".equals(format)) {
            result = AudioUtils.getMp3Duration(filePath).intValue();
        } else if ("m4a".equals(format)) {
            result = VideoUtils.getMp4Duration(filePath);
        } else if ("mov".equals(format)) {
            result = VideoUtils.getMp4Duration(filePath);
        } else if ("mp4".equals(format)) {
            result = VideoUtils.getMp4Duration(filePath);
        }
        return result;
    }

    public static long getDuration(String filePath, String format) throws IOException {
        long result = 0L;
        if ("wav".equals(format)) {
            result = AudioUtils.getDuration(filePath).intValue();
        } else if ("mp3".equals(format)) {
            result = AudioUtils.getMp3Duration(filePath).intValue();
        } else if ("m4a".equals(format)) {
            result = VideoUtils.getMp4Duration(filePath);
        } else if ("mov".equals(format)) {
            result = VideoUtils.getMp4Duration(filePath);
        } else if ("mp4".equals(format)) {
            result = VideoUtils.getMp4Duration(filePath);
        }
        return result;
    }

    public static String getVideoFormat(String path) {
        String lowerCase = path.toLowerCase();
        return lowerCase.substring(lowerCase.lastIndexOf(".") + 1);
    }
}

