/*
 * Decompiled with CFR 0.152.
 */
package com.example.graphqldemo.api;

import com.example.graphqldemo.api.OidcRestClientResponseHandler;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.kobylynskyi.graphql.codegen.model.graphql.GraphQLOperationRequest;
import com.kobylynskyi.graphql.codegen.model.graphql.GraphQLRequest;
import com.kobylynskyi.graphql.codegen.model.graphql.GraphQLResponseProjection;
import com.kobylynskyi.graphql.codegen.model.graphql.GraphQLResult;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TimeZone;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public abstract class Api {
    public URI endpoint;
    public CloseableHttpClient restKlient;
    public static final List<Integer> HTTP_KODER_TOM_RESPONS = new ArrayList<Integer>(Arrays.asList(304, 204, 202));
    public static final ObjectMapper MAPPER = Api.mapper();

    public static ObjectMapper mapper() {
        return new ObjectMapper().registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule()).setPropertyNamingStrategy(PropertyNamingStrategy.LOWER_CAMEL_CASE).setTimeZone(TimeZone.getTimeZone("Europe/Oslo")).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).disable(SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).configure(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN, true).enable(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY).enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    Api(String url) {
        this.endpoint = Api.validate(URI.create(url));
        this.restKlient = HttpClients.custom().build();
    }

    Api(URI endpoint, String tema, CloseableHttpClient klient) {
        this.endpoint = Api.validate(endpoint);
        this.restKlient = klient;
    }

    public static URI validate(URI endpoint) {
        return endpoint;
    }

    public <T extends GraphQLResult<?>> T query(GraphQLOperationRequest q, GraphQLResponseProjection p, Class<T> clazz) throws Exception {
        return this.query(new GraphQLRequest(q, p), clazz);
    }

    public <T extends GraphQLResult<?>> T query(GraphQLRequest req, Class<T> clazz) throws Exception {
        Object res = this.sendReq(this.post(req), new OidcRestClientResponseHandler.ObjectReaderResponseHandler(this.endpoint, MAPPER.readerFor(clazz)));
        if (res.hasErrors()) {
            throw new Exception("\u8bf7\u6c42\u5f02\u5e38");
        }
        return res;
    }

    public HttpPost post(GraphQLRequest req) {
        try {
            HttpPost post = new HttpPost(this.endpoint);
            post.setEntity((HttpEntity)new StringEntity(req.toHttpJsonBody()));
            post.setHeader("Content-Type", "application/json; charset=utf8");
            return post;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public <T extends GraphQLResult<?>> T sendReq(HttpPost req, OidcRestClientResponseHandler.ObjectReaderResponseHandler<T> responseHandler) throws Exception {
        CloseableHttpResponse res = this.restKlient.execute((HttpUriRequest)req);
        Integer status = res.getStatusLine().getStatusCode();
        if (status == 200) {
            return (T)((GraphQLResult)responseHandler.handleResponse((HttpResponse)res));
        }
        String body = HTTP_KODER_TOM_RESPONS.contains(status) ? "<tom_respons>" : EntityUtils.toString((HttpEntity)res.getEntity());
        String msg = "Kunne ikke hente informasjon for query mot PDL: " + req.getURI() + ", HTTP request=" + req.getEntity() + ", HTTP status=" + res.getStatusLine() + ". HTTP Errormessage=" + body;
        throw new Exception(msg);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [endpoint=" + this.endpoint + ", restKlient=" + this.restKlient + "]";
    }
}

