/*
 * Decompiled with CFR 0.152.
 */
package com.example.graphqldemo.api;

import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;

public abstract class OidcRestClientResponseHandler<T>
implements ResponseHandler<T> {
    private final URI endpoint;

    public OidcRestClientResponseHandler(URI endpoint) {
        this.endpoint = endpoint;
    }

    public T handleResponse(HttpResponse response) throws IOException {
        int status = response.getStatusLine().getStatusCode();
        if (status == 204) {
            return null;
        }
        if (status >= 200 && status < 300) {
            HttpEntity entity = response.getEntity();
            return entity != null ? (T)this.readEntity(entity) : null;
        }
        if (status == 403) {
            throw new IOException();
        }
        throw new IOException();
    }

    protected abstract T readEntity(HttpEntity var1) throws IOException;

    public static class ObjectReaderResponseHandler<T>
    extends OidcRestClientResponseHandler<T> {
        private ObjectReader reader;

        public ObjectReaderResponseHandler(URI endpoint, ObjectReader reader) {
            super(endpoint);
            this.reader = reader;
        }

        @Override
        protected T readEntity(HttpEntity entity) throws IOException {
            return (T)this.reader.readValue(entity.getContent());
        }
    }

    public static class ByteArrayResponseHandler
    extends OidcRestClientResponseHandler<byte[]> {
        public ByteArrayResponseHandler(URI endpoint) {
            super(endpoint);
        }

        @Override
        protected byte[] readEntity(HttpEntity entity) throws IOException {
            return EntityUtils.toByteArray((HttpEntity)entity);
        }
    }

    public static class StringResponseHandler
    extends OidcRestClientResponseHandler<String> {
        public StringResponseHandler(URI endpoint) {
            super(endpoint);
        }

        @Override
        protected String readEntity(HttpEntity entity) throws IOException {
            return EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
        }
    }
}

