/*
 * Decompiled with CFR 0.152.
 */
package com.luckypeng.mock.core.function;

import com.alibaba.fastjson.JSON;
import com.luckypeng.mock.core.function.BasicFunction;
import com.luckypeng.mock.core.function.schema.Function;
import com.luckypeng.mock.core.function.schema.Functions;
import com.luckypeng.mock.core.util.ObjectUtils;
import java.util.List;

@Functions
public class AddressFunction {
    public static String[] REGION = new String[]{"\u4e1c\u5317", "\u534e\u5317", "\u534e\u4e1c", "\u534e\u4e2d", "\u534e\u5357", "\u897f\u5357", "\u897f\u5317"};
    public static List<Province> CHINA = JSON.parseArray((String)ObjectUtils.fromFile("china.json"), Province.class);

    private AddressFunction() {
    }

    @Function
    public static String region() {
        return BasicFunction.pick(REGION);
    }

    @Function
    public static String province() {
        return BasicFunction.pick(CHINA).getName();
    }

    @Function
    public static String city() {
        return AddressFunction.city(false);
    }

    @Function
    public static String city(boolean prefix) {
        Province province = BasicFunction.pick(CHINA);
        String city = BasicFunction.pick(province.getCity()).getName();
        return prefix ? province.getName() + " " + city : city;
    }

    @Function
    public static String county() {
        return AddressFunction.county(false);
    }

    @Function
    public static String county(boolean prefix) {
        Province province = BasicFunction.pick(CHINA);
        City city = BasicFunction.pick(province.getCity());
        String country = BasicFunction.pick(city.getArea());
        return prefix ? province.getName() + " " + city.getName() + " " + country : country;
    }

    @Function
    public static String zip() {
        return BasicFunction.string(BasicFunction.CharacterEnum.number, 6);
    }

    public static class City {
        private String name;
        private List<String> area;

        public String getName() {
            return this.name;
        }

        public List<String> getArea() {
            return this.area;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setArea(List<String> area) {
            this.area = area;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof City)) {
                return false;
            }
            City other = (City)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            List<String> this$area = this.getArea();
            List<String> other$area = other.getArea();
            return !(this$area == null ? other$area != null : !((Object)this$area).equals(other$area));
        }

        protected boolean canEqual(Object other) {
            return other instanceof City;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            List<String> $area = this.getArea();
            result = result * 59 + ($area == null ? 43 : ((Object)$area).hashCode());
            return result;
        }

        public String toString() {
            return "AddressFunction.City(name=" + this.getName() + ", area=" + this.getArea() + ")";
        }
    }

    public static class Province {
        private String name;
        private List<City> city;

        public String getName() {
            return this.name;
        }

        public List<City> getCity() {
            return this.city;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setCity(List<City> city) {
            this.city = city;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Province)) {
                return false;
            }
            Province other = (Province)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            List<City> this$city = this.getCity();
            List<City> other$city = other.getCity();
            return !(this$city == null ? other$city != null : !((Object)this$city).equals(other$city));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Province;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            List<City> $city = this.getCity();
            result = result * 59 + ($city == null ? 43 : ((Object)$city).hashCode());
            return result;
        }

        public String toString() {
            return "AddressFunction.Province(name=" + this.getName() + ", city=" + this.getCity() + ")";
        }
    }
}

