/*
 * Decompiled with CFR 0.152.
 */
package com.luckypeng.mock.core.function;

import com.luckypeng.mock.core.function.schema.Function;
import com.luckypeng.mock.core.function.schema.Functions;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.RandomUtils;

@Functions
public class BasicFunction {
    public static final long DEFAULT_FLOAT_MIN = Long.MIN_VALUE;
    public static final long DEFAULT_FLOAT_MAX = Long.MAX_VALUE;
    public static final int DEFAULT_FLOAT_D_MIN = 0;
    public static final int DEFAULT_FLOAT_D_MAX = 16;
    public static final int DEFAULT_STRING_MIN = 3;
    public static final int DEFAULT_STRING_MAX = 7;

    private BasicFunction() {
    }

    @Function(alias={"boolean"})
    public static boolean bool() {
        return RandomUtils.nextBoolean();
    }

    @Function(alias={"boolean"})
    public static boolean bool(double min, double max, boolean current) {
        return Math.random() > 1.0 / (min + max) * min ? !current : current;
    }

    @Function(alias={"int"})
    public static long natural() {
        return BasicFunction.integer(0L);
    }

    @Function(alias={"int"})
    public static long integer() {
        return BasicFunction.integer(Long.MIN_VALUE);
    }

    @Function(alias={"int", "natural"})
    public static long integer(long min) {
        return BasicFunction.integer(min, Long.MAX_VALUE);
    }

    @Function(alias={"int", "natural"})
    public static long integer(long min, long max) {
        return Math.round(Math.random() * (double)(max - min)) + min;
    }

    @Function(alias={"float"})
    public static double decimal() {
        return BasicFunction.decimal(Long.MIN_VALUE);
    }

    @Function(alias={"float"})
    public static double decimal(long min) {
        return BasicFunction.decimal(min, Long.MAX_VALUE);
    }

    @Function(alias={"float"})
    public static double decimal(long min, long max) {
        return BasicFunction.decimal(min, max, 0);
    }

    @Function(alias={"float"})
    public static double decimal(long min, long max, int dMin) {
        return BasicFunction.decimal(min, max, dMin, 16);
    }

    @Function(alias={"float"})
    public static double decimal(long min, long max, int dMin, int dMax) {
        return new BigDecimal((double)BasicFunction.integer(min, max) + RandomUtils.nextDouble((double)0.0, (double)1.0)).setScale((int)BasicFunction.integer(dMin, dMax), 3).doubleValue();
    }

    @Function(alias={"char"})
    public static char character() {
        return BasicFunction.character(CharacterEnum.ALL);
    }

    @Function(alias={"char"})
    public static char character(CharacterEnum characterEnum) {
        return BasicFunction.character(characterEnum.getPool());
    }

    @Function(alias={"char"})
    public static char character(String pool) {
        pool = CharacterEnum.searchPool(pool);
        return pool.charAt((int)BasicFunction.integer(0L, pool.length() - 1));
    }

    @Function(alias={"str"})
    public static String string() {
        return BasicFunction.string(3, 7);
    }

    @Function(alias={"str"})
    public static String string(int length) {
        return BasicFunction.string(CharacterEnum.ALL, length);
    }

    @Function(alias={"str"})
    public static String string(int min, int max) {
        return BasicFunction.string(CharacterEnum.ALL, min, max);
    }

    @Function(alias={"str"})
    public static String string(CharacterEnum characterEnum, int min, int max) {
        return BasicFunction.string(characterEnum.getPool(), min, max);
    }

    @Function(alias={"str"})
    public static String string(String pool, int min, int max) {
        return BasicFunction.string(pool, (int)BasicFunction.integer(min, max));
    }

    @Function(alias={"str"})
    public static String string(CharacterEnum characterEnum, int length) {
        return BasicFunction.string(characterEnum.getPool(), length);
    }

    @Function(alias={"str"})
    public static String string(String pool, int length) {
        pool = CharacterEnum.searchPool(pool);
        String text = "";
        for (int i = 0; i < length; ++i) {
            text = text + BasicFunction.character(pool);
        }
        return text;
    }

    @Function
    public static int[] range(int stop) {
        return BasicFunction.range(0, stop);
    }

    @Function
    public static int[] range(int start, int stop) {
        return BasicFunction.range(start, stop, 1);
    }

    @Function
    public static int[] range(int start, int stop, int step) {
        int length = (stop - 1 - start) / step + 1;
        int[] result = new int[length];
        int i = 0;
        while (i < length) {
            result[i] = start;
            ++i;
            start += step;
        }
        return result;
    }

    public static <T> T pick(T[] array) {
        return array[(int)BasicFunction.integer(0L, array.length - 1)];
    }

    public static <T> T pick(List<T> list) {
        return list.get((int)BasicFunction.integer(0L, list.size() - 1));
    }

    @Function(alias={"pick"})
    public static Object pickOne(Object[] array) {
        return BasicFunction.pick(array);
    }

    public static enum CharacterEnum {
        lower("abcdefghijklmnopqrstuvwxyz"),
        upper("ABCDEFGHIJKLMNOPQRSTUVWXYZ"),
        number("0123456789"),
        symbol("!@#$%^&*()[]");

        private String pool;
        public static String ALL;

        private CharacterEnum(String pool) {
            this.pool = pool;
        }

        public static String searchPool(String pool) {
            CharacterEnum existPool = (CharacterEnum)EnumUtils.getEnum(CharacterEnum.class, (String)pool);
            if (existPool != null) {
                return existPool.getPool();
            }
            return pool;
        }

        public String getPool() {
            return this.pool;
        }

        static {
            ALL = "";
            for (CharacterEnum value : CharacterEnum.values()) {
                ALL = ALL + value.pool;
            }
        }
    }
}

