/*
 * Decompiled with CFR 0.152.
 */
package com.luckypeng.mock.core.function;

import com.luckypeng.mock.core.function.BasicFunction;
import com.luckypeng.mock.core.function.schema.Function;
import com.luckypeng.mock.core.function.schema.Functions;
import com.luckypeng.mock.core.util.DateUtils;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.EnumUtils;
import org.joda.time.DateTime;

@Functions
public class DateFunction {
    private static final Pattern RE_UNIT = Pattern.compile("year|month|day|hour|minute|second|week");

    private DateFunction() {
    }

    @Function
    public static long timestamp() {
        return DateFunction.timestamp(false);
    }

    @Function
    public static long timestamp(boolean isNow) {
        if (isNow) {
            return System.currentTimeMillis();
        }
        return BasicFunction.integer(0L, System.currentTimeMillis());
    }

    @Function
    public static String datetime() {
        return DateFunction.datetime("yyyy-MM-dd HH:mm:ss");
    }

    @Function
    public static String date() {
        return DateFunction.datetime("yyyy-MM-dd");
    }

    @Function
    public static String time() {
        return DateFunction.datetime("HH:mm:ss");
    }

    @Function(alias={"date", "time"})
    public static String datetime(String format) {
        long ts = BasicFunction.integer(0L, System.currentTimeMillis());
        return DateUtils.toDateTimeString(DateUtils.fromTimeStamp(ts), format);
    }

    @Function
    public static String now() {
        return DateFunction.now(DateUnit.second.name());
    }

    @Function
    public static String now(String unitOrFormat) {
        String unit = "";
        String format = "yyyy-MM-dd HH:mm:ss";
        Matcher matcher = RE_UNIT.matcher(unitOrFormat);
        if (matcher.matches()) {
            unit = unitOrFormat;
        } else {
            format = unitOrFormat;
        }
        return DateFunction.now(unit, format);
    }

    @Function
    public static String now(String unit, String format) {
        DateTime dateTime = DateTime.now();
        DateUnit dateUnit = (DateUnit)EnumUtils.getEnum(DateUnit.class, (String)unit);
        switch (dateUnit) {
            case year: {
                dateTime = dateTime.withMonthOfYear(1);
            }
            case month: {
                dateTime = dateTime.withDayOfMonth(1);
            }
            case week: 
            case day: {
                dateTime = dateTime.withHourOfDay(0);
            }
            case hour: {
                dateTime = dateTime.withMinuteOfHour(0);
            }
            case minute: {
                dateTime = dateTime.withSecondOfMinute(0);
            }
            case second: {
                dateTime = dateTime.withMillisOfSecond(0);
            }
        }
        if (DateUnit.week.equals((Object)dateUnit)) {
            dateTime = dateTime.withDayOfWeek(1);
        }
        return dateTime.toString(format, Locale.CHINESE);
    }

    private static enum DateUnit {
        year,
        month,
        week,
        day,
        hour,
        minute,
        second;

    }
}

