/*
 * Decompiled with CFR 0.152.
 */
package com.luckypeng.mock.core.function.schema;

public class ParamType {
    private static final int INT = 1;
    private static final int LONG = 2;
    private static final int DOUBLE = 3;
    private static final int BOOLEAN = 4;
    private static final int STRING = 5;
    private static final int OBJECT_ARRAY = 6;
    private static final String TRUE = "true";
    private static final String FALSE = "false";

    public static Object toSpecificType(String value) {
        if (TRUE.equals(value) || FALSE.equals(value)) {
            return Boolean.parseBoolean(value);
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException e1) {
                try {
                    return Double.parseDouble(value);
                }
                catch (NumberFormatException e2) {
                    return value;
                }
            }
        }
    }

    public static boolean isFitType(Object value, Class type) {
        int classType = ParamType.getValueType(value);
        type = ParamType.getNonPrimitiveClass(type);
        switch (classType) {
            case 1: {
                return type == Integer.class || type == Long.class || type == Double.class;
            }
            case 2: {
                return type == Long.class;
            }
            case 3: {
                return type == Double.class;
            }
            case 4: {
                return type == Boolean.class;
            }
            case 5: {
                return type == String.class;
            }
            case 6: {
                return type == Object[].class;
            }
        }
        return false;
    }

    private static int getValueType(Object value) {
        if (value instanceof Integer) {
            return 1;
        }
        if (value instanceof Long) {
            return 2;
        }
        if (value instanceof Double) {
            return 3;
        }
        if (value instanceof Boolean) {
            return 4;
        }
        if (value instanceof String) {
            return 5;
        }
        if (value instanceof Object[]) {
            return 6;
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u7684\u89e3\u6790: " + value);
    }

    public static Class<?> getNonPrimitiveClass(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Void.TYPE) {
            return Void.class;
        }
        return clazz;
    }
}

