/*
 * Decompiled with CFR 0.152.
 */
package com.luckypeng.mock.core.function.util;

import com.luckypeng.mock.core.function.schema.Function;
import com.luckypeng.mock.core.function.schema.Functions;
import com.luckypeng.mock.core.function.schema.MockFunction;
import com.luckypeng.mock.core.function.schema.ParamType;
import com.luckypeng.mock.core.io.ClassScanner;
import com.luckypeng.mock.core.template.Rule;
import com.luckypeng.mock.core.util.AssertionUtils;
import com.luckypeng.mock.core.util.ObjectUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionHelper {
    private static final Logger log = LoggerFactory.getLogger(FunctionHelper.class);
    public static Map<String, List<MockFunction>> MOCK_FUNCTIONS;

    private FunctionHelper() {
    }

    public static Object execFunction(String funcExpression) {
        String[] functionAndParams = Rule.parsePlaceholder(funcExpression);
        String funcName = functionAndParams[0];
        Object[] params = FunctionHelper.resolveParams(functionAndParams[1]);
        List<MockFunction> functions = MOCK_FUNCTIONS.get(funcName);
        AssertionUtils.notEmpty(functions, "\u4e0d\u652f\u6301\u8be5\u51fd\u6570: " + funcName);
        for (MockFunction function : functions) {
            boolean paramsMatched;
            boolean isFit = true;
            Class<?>[] classes = function.getMethod().getParameterTypes();
            boolean bl = paramsMatched = ObjectUtils.isEmpty(params) && ObjectUtils.isEmpty(classes) || params != null && params.length == classes.length;
            if (paramsMatched) {
                for (int i = 0; params != null && i < params.length; ++i) {
                    if (ParamType.isFitType(params[i], classes[i])) continue;
                    isFit = false;
                }
            } else {
                isFit = false;
            }
            if (!isFit) continue;
            log.debug("\u5df2\u627e\u5230\u5bf9\u5e94\u7684\u51fd\u6570: " + function.toString());
            try {
                return function.getMethod().invoke(null, params);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("\u51fd\u6570\u6267\u884c\u51fa\u9519: " + funcName, e);
            }
        }
        throw new RuntimeException("\u8be5\u51fd\u6570\u6ca1\u6709\u5339\u914d\u7684\u53c2\u6570\u7c7b\u578b: " + funcName);
    }

    private static Object[] resolveParams(String paramStr) {
        if (StringUtils.isEmpty((CharSequence)paramStr)) {
            return null;
        }
        if (paramStr.startsWith("[")) {
            AssertionUtils.isTrue(paramStr.endsWith("]") && paramStr.length() > 2, "\u53c2\u6570\u4e3a\u6570\u7ec4\u65f6\u5fc5\u987b\u4ee5[]\u8fdb\u884c\u5305\u88f9\u4e14\u6570\u7ec4\u4e0d\u4e3a\u7a7a");
            Object[] params = FunctionHelper.splitParams(paramStr.substring(1, paramStr.length() - 1));
            return new Object[]{params};
        }
        Object[] params = FunctionHelper.splitParams(paramStr);
        return params;
    }

    private static Object[] splitParams(String paramStr) {
        if (ObjectUtils.isEmpty(paramStr)) {
            return new Object[0];
        }
        String[] paramStrArray = paramStr.split(" *, *");
        Object[] params = new Object[paramStrArray.length];
        for (int i = 0; i < paramStrArray.length; ++i) {
            paramStrArray[i] = paramStrArray[i].trim();
            params[i] = paramStrArray[i].charAt(0) == '\'' ? paramStrArray[i].substring(1, paramStrArray[i].length() - 1) : ParamType.toSpecificType(paramStrArray[i]);
        }
        return params;
    }

    static {
        List<Class> mockClassList = ClassScanner.scan("com.luckypeng.mock.core.function", Functions.class);
        MOCK_FUNCTIONS = mockClassList.stream().flatMap(clazz -> Arrays.stream(clazz.getMethods())).filter(method -> method.isAnnotationPresent(Function.class)).flatMap(method -> {
            Function info = method.getAnnotation(Function.class);
            ArrayList<MockFunction> functions = new ArrayList<MockFunction>();
            functions.add(new MockFunction(method.getName(), info.desc(), (Method)method));
            for (String alias : info.alias()) {
                functions.add(new MockFunction(alias, info.desc(), (Method)method));
            }
            return functions.stream();
        }).collect(Collectors.groupingBy(MockFunction::getName));
    }
}

