/*
 * Decompiled with CFR 0.152.
 */
package com.luckypeng.mock.core.io;

import com.luckypeng.mock.core.io.ResourceType;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassScanner {
    private static final Logger log = LoggerFactory.getLogger(ClassScanner.class);
    private static final String PATH_DELIMITER = "/";

    public static List<Class> scan(String packageName, Class annotationClass) {
        List<Class> classes = ClassScanner.scan(packageName);
        return classes.stream().filter(clazz -> clazz.getAnnotation(annotationClass) != null).collect(Collectors.toList());
    }

    public static List<Class> scan(String packageName) {
        List<String> classNames = ClassScanner.scanClass(packageName);
        ArrayList<Class> classes = new ArrayList<Class>();
        classNames.forEach(className -> {
            try {
                classes.add(Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("\u83b7\u53d6\u6307\u5b9a\u7c7b\u5931\u8d25: " + className, e);
            }
        });
        return classes;
    }

    public static List<String> scanClass(String packageName) {
        Enumeration<URL> urls;
        String packagePath = ClassScanner.packageToPath(packageName);
        List<String> list = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            urls = classLoader.getResources(packagePath);
        }
        catch (IOException e) {
            throw new RuntimeException("\u67e5\u627e\u5305\u4e0b\u7684\u8d44\u6e90\u5931\u8d25: " + packagePath, e);
        }
        while (urls.hasMoreElements()) {
            URL u = urls.nextElement();
            ResourceType type = ClassScanner.determineType(u);
            switch (type) {
                case JAR: {
                    String path = ClassScanner.distillPathFromJarURL(u.getPath());
                    list = ClassScanner.scanJar(path, packagePath);
                    break;
                }
                case FILE: {
                    String filePath;
                    try {
                        filePath = URLDecoder.decode(u.getPath(), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException("URLDecoder.decode URL \u5931\u8d25: ", e);
                    }
                    list = ClassScanner.scanFile(filePath, packageName);
                    break;
                }
            }
        }
        return list;
    }

    private static ResourceType determineType(URL url) {
        if (url.getProtocol().equals(ResourceType.FILE.getTypeString())) {
            return ResourceType.FILE;
        }
        if (url.getProtocol().equals(ResourceType.JAR.getTypeString())) {
            return ResourceType.JAR;
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u8be5\u7c7b\u578b: " + url.getProtocol());
    }

    private static List<String> scanJar(String path, String packagePath) {
        JarFile jar;
        try {
            jar = new JarFile(path);
        }
        catch (IOException e) {
            throw new RuntimeException("\u6253\u5f00JAR\u6587\u4ef6\u5931\u8d25: " + path, e);
        }
        ArrayList<String> classNameList = new ArrayList<String>(20);
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.startsWith(packagePath) || !name.endsWith(ResourceType.CLASS_FILE.getTypeString()) || -1 != (name = ClassScanner.trimSuffix(name)).lastIndexOf("$")) continue;
            name = ClassScanner.pathToPackage(name);
            classNameList.add(name);
        }
        return classNameList;
    }

    private static List<String> scanFile(String path, String packageName) {
        File f = new File(path);
        ArrayList<String> classNameList = new ArrayList<String>(10);
        File[] files = f.listFiles();
        if (null != files) {
            for (File file : files) {
                String className;
                if (file.isDirectory()) {
                    List<String> list = ClassScanner.scanFile(file.getAbsolutePath(), ClassScanner.concat(packageName, ".", file.getName()));
                    classNameList.addAll(list);
                    continue;
                }
                if (!file.getName().endsWith(ResourceType.CLASS_FILE.getTypeString()) || -1 != (className = ClassScanner.trimSuffix(file.getName())).lastIndexOf("$")) continue;
                String result = ClassScanner.concat(packageName, ".", className);
                classNameList.add(result);
            }
        } else {
            log.warn(path + " \u76ee\u5f55\u4e0b\u6ca1\u6709\u6587\u4ef6\uff01");
        }
        return classNameList;
    }

    public static String pathToPackage(String path) {
        if (path.startsWith(PATH_DELIMITER)) {
            path = path.substring(1);
        }
        return path.replaceAll(PATH_DELIMITER, ".");
    }

    public static String packageToPath(String packageName) {
        return packageName.replace(".", PATH_DELIMITER);
    }

    public static String concat(Object ... objects) {
        StringBuilder sb = new StringBuilder(30);
        for (int ix = 0; ix < objects.length; ++ix) {
            sb.append(objects[ix]);
        }
        return sb.toString();
    }

    public static String trimSuffix(String name) {
        int dotIndex = name.indexOf(46);
        if (-1 == dotIndex) {
            return name;
        }
        return name.substring(0, dotIndex);
    }

    public static String distillPathFromJarURL(String url) {
        int startPos = url.indexOf(58);
        int endPos = url.lastIndexOf(33);
        return url.substring(startPos + 1, endPos);
    }
}

