/*
 * Decompiled with CFR 0.152.
 */
package com.luckypeng.mock.core.template;

import com.luckypeng.mock.core.function.BasicFunction;
import com.luckypeng.mock.core.util.AssertionUtils;
import com.luckypeng.mock.core.util.NumberUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Rule {
    private String key;
    private boolean range;
    private Long min;
    private Long max;
    private Long count;
    private boolean decimal;
    private Integer dMin;
    private Integer dMax;
    private Integer dCount;
    private Integer step;
    private static final Pattern RE_KEY = Pattern.compile("([^\\|]+)\\|?(?:\\+(\\d+)|([\\+-]?\\d+-?[\\+-]?\\d*)?(\\.\\d+-?\\d*)?)");
    private static final Pattern RE_RANGE = Pattern.compile("([\\+-]?\\d+)-?([\\+-]?\\d+)?");
    private static final Pattern RE_PLACEHOLDER = Pattern.compile("@([^@#%&()\\?\\s]+)(\\((.*)\\))?");

    public static Rule fromKey(String key) {
        Rule rule = new Rule();
        Matcher matcher = RE_KEY.matcher(key);
        if (matcher.find()) {
            Matcher rangeMatcher;
            rule.setKey(matcher.group(1));
            rule.setStep(NumberUtils.parseInt(matcher.group(2)));
            rule.setRange(matcher.group(3) != null);
            if (rule.isRange()) {
                rangeMatcher = RE_RANGE.matcher(matcher.group(3));
                if (rangeMatcher.find()) {
                    rule.setMin(NumberUtils.parseLong(rangeMatcher.group(1)));
                    rule.setMax(NumberUtils.parseLong(rangeMatcher.group(2)));
                }
                rule.setCount(rule.getMax() == null ? rule.getMin() : BasicFunction.integer(rule.getMin(), rule.getMax()));
            }
            rule.setDecimal(matcher.group(4) != null);
            if (rule.isDecimal()) {
                rangeMatcher = RE_RANGE.matcher(matcher.group(4));
                if (rangeMatcher.find()) {
                    rule.setDMin(NumberUtils.parseInt(rangeMatcher.group(1)));
                    rule.setDMax(NumberUtils.parseInt(rangeMatcher.group(2)));
                }
                rule.setDCount(rule.getDMax() == null ? rule.getDMin() : (int)BasicFunction.integer(rule.getDMin().intValue(), rule.getDMax().intValue()));
            }
        }
        return rule;
    }

    public static boolean isPlaceholder(String value) {
        Matcher matcher = RE_PLACEHOLDER.matcher(value);
        return matcher.matches();
    }

    public static String[] parsePlaceholder(String value) {
        Matcher matcher = RE_PLACEHOLDER.matcher(value);
        AssertionUtils.isTrue(matcher.find(), "\u8be5\u5b57\u7b26\u4e32\u4e0d\u662f\u5360\u4f4d\u7b26: " + value);
        String params = matcher.group(2);
        return new String[]{matcher.group(1), params == null ? "" : params.substring(1, params.length() - 1)};
    }

    public String getKey() {
        return this.key;
    }

    public boolean isRange() {
        return this.range;
    }

    public Long getMin() {
        return this.min;
    }

    public Long getMax() {
        return this.max;
    }

    public Long getCount() {
        return this.count;
    }

    public boolean isDecimal() {
        return this.decimal;
    }

    public Integer getDMin() {
        return this.dMin;
    }

    public Integer getDMax() {
        return this.dMax;
    }

    public Integer getDCount() {
        return this.dCount;
    }

    public Integer getStep() {
        return this.step;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setRange(boolean range) {
        this.range = range;
    }

    public void setMin(Long min) {
        this.min = min;
    }

    public void setMax(Long max) {
        this.max = max;
    }

    public void setCount(Long count) {
        this.count = count;
    }

    public void setDecimal(boolean decimal) {
        this.decimal = decimal;
    }

    public void setDMin(Integer dMin) {
        this.dMin = dMin;
    }

    public void setDMax(Integer dMax) {
        this.dMax = dMax;
    }

    public void setDCount(Integer dCount) {
        this.dCount = dCount;
    }

    public void setStep(Integer step) {
        this.step = step;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Rule)) {
            return false;
        }
        Rule other = (Rule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        if (this.isRange() != other.isRange()) {
            return false;
        }
        Long this$min = this.getMin();
        Long other$min = other.getMin();
        if (this$min == null ? other$min != null : !((Object)this$min).equals(other$min)) {
            return false;
        }
        Long this$max = this.getMax();
        Long other$max = other.getMax();
        if (this$max == null ? other$max != null : !((Object)this$max).equals(other$max)) {
            return false;
        }
        Long this$count = this.getCount();
        Long other$count = other.getCount();
        if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
            return false;
        }
        if (this.isDecimal() != other.isDecimal()) {
            return false;
        }
        Integer this$dMin = this.getDMin();
        Integer other$dMin = other.getDMin();
        if (this$dMin == null ? other$dMin != null : !((Object)this$dMin).equals(other$dMin)) {
            return false;
        }
        Integer this$dMax = this.getDMax();
        Integer other$dMax = other.getDMax();
        if (this$dMax == null ? other$dMax != null : !((Object)this$dMax).equals(other$dMax)) {
            return false;
        }
        Integer this$dCount = this.getDCount();
        Integer other$dCount = other.getDCount();
        if (this$dCount == null ? other$dCount != null : !((Object)this$dCount).equals(other$dCount)) {
            return false;
        }
        Integer this$step = this.getStep();
        Integer other$step = other.getStep();
        return !(this$step == null ? other$step != null : !((Object)this$step).equals(other$step));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Rule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        result = result * 59 + (this.isRange() ? 79 : 97);
        Long $min = this.getMin();
        result = result * 59 + ($min == null ? 43 : ((Object)$min).hashCode());
        Long $max = this.getMax();
        result = result * 59 + ($max == null ? 43 : ((Object)$max).hashCode());
        Long $count = this.getCount();
        result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
        result = result * 59 + (this.isDecimal() ? 79 : 97);
        Integer $dMin = this.getDMin();
        result = result * 59 + ($dMin == null ? 43 : ((Object)$dMin).hashCode());
        Integer $dMax = this.getDMax();
        result = result * 59 + ($dMax == null ? 43 : ((Object)$dMax).hashCode());
        Integer $dCount = this.getDCount();
        result = result * 59 + ($dCount == null ? 43 : ((Object)$dCount).hashCode());
        Integer $step = this.getStep();
        result = result * 59 + ($step == null ? 43 : ((Object)$step).hashCode());
        return result;
    }

    public String toString() {
        return "Rule(key=" + this.getKey() + ", range=" + this.isRange() + ", min=" + this.getMin() + ", max=" + this.getMax() + ", count=" + this.getCount() + ", decimal=" + this.isDecimal() + ", dMin=" + this.getDMin() + ", dMax=" + this.getDMax() + ", dCount=" + this.getDCount() + ", step=" + this.getStep() + ")";
    }
}

