/*
 * Decompiled with CFR 0.152.
 */
package com.luckypeng.mock.core.template;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.luckypeng.mock.core.function.BasicFunction;
import com.luckypeng.mock.core.function.util.FunctionHelper;
import com.luckypeng.mock.core.template.Rule;
import com.luckypeng.mock.core.util.NumberUtils;
import com.luckypeng.mock.core.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class TemplateHandler {
    public static Object handle(String key, Object value) {
        Rule rule = Rule.fromKey(key);
        return TemplateHandler.handle(rule, value);
    }

    public static Object handle(Rule rule, Object value) {
        if (value instanceof Boolean) {
            return TemplateHandler.handle(rule, (Boolean)value);
        }
        if (value instanceof Number) {
            return TemplateHandler.handle(rule, (Number)value);
        }
        if (value instanceof String) {
            return TemplateHandler.handle(rule, (String)value);
        }
        if (value instanceof JSONObject) {
            return TemplateHandler.handle(rule, (JSONObject)value);
        }
        if (value instanceof JSONArray) {
            return TemplateHandler.handle(rule, (JSONArray)value);
        }
        throw new RuntimeException("\u6682\u65f6\u4e0d\u652f\u6301\u8be5\u7c7b\u578b\u6570\u636e");
    }

    public static Object handle(Object value) {
        if (value instanceof Boolean) {
            return TemplateHandler.handle((Boolean)value);
        }
        if (value instanceof Number) {
            return TemplateHandler.handle((Number)value);
        }
        if (value instanceof String) {
            return TemplateHandler.handle((String)value);
        }
        if (value instanceof JSONObject) {
            return TemplateHandler.handle((JSONObject)value);
        }
        if (value instanceof JSONArray) {
            return TemplateHandler.handle((JSONArray)value);
        }
        throw new RuntimeException("\u6682\u65f6\u4e0d\u652f\u6301\u8be5\u7c7b\u578b\u6570\u636e");
    }

    public static boolean handle(Rule rule, boolean value) {
        return rule.isRange() ? BasicFunction.bool(ObjectUtils.coalesce(rule.getMin(), 1L).longValue(), ObjectUtils.coalesce(rule.getMax(), 1L).longValue(), value) : TemplateHandler.handle(value);
    }

    public static boolean handle(boolean value) {
        return value;
    }

    public static Number handle(Rule rule, Number value) {
        if (rule.isDecimal()) {
            return BasicFunction.decimal(ObjectUtils.coalesce(rule.getMin(), Long.MIN_VALUE), ObjectUtils.coalesce(rule.getMax(), Long.MAX_VALUE), ObjectUtils.coalesce(rule.getDMin(), 0), ObjectUtils.coalesce(rule.getDMax(), 16));
        }
        return rule.isRange() ? (Number)rule.getCount() : (Number)TemplateHandler.handle(value);
    }

    public static Number handle(Number value) {
        return value;
    }

    public static Object handle(Rule rule, String value) {
        Object placeholderResult = TemplateHandler.handle(value);
        if (!rule.isRange()) {
            return placeholderResult;
        }
        String result = "";
        int i = 0;
        while ((long)i < rule.getCount()) {
            result = result + placeholderResult.toString();
            ++i;
        }
        return result;
    }

    public static Object handle(String value) {
        if (Rule.isPlaceholder(value)) {
            return FunctionHelper.execFunction(value);
        }
        return value;
    }

    public static JSONObject handle(Rule rule, JSONObject value) {
        if (value.isEmpty()) {
            return value;
        }
        if (rule.isRange()) {
            int size = Math.min(rule.getCount().intValue(), value.size());
            ArrayList randomKeys = new ArrayList(value.keySet());
            Collections.shuffle(randomKeys);
            JSONObject randomValue = new JSONObject(size, true);
            for (int i = 0; i < size; ++i) {
                String subKey = (String)randomKeys.get(i);
                randomValue.put(subKey, value.get((Object)subKey));
            }
            return TemplateHandler.handle(randomValue);
        }
        return TemplateHandler.handle(value);
    }

    public static JSONObject handle(JSONObject value) {
        if (value.isEmpty()) {
            return value;
        }
        JSONObject result = new JSONObject(value.size(), true);
        value.entrySet().stream().forEach(kv -> {
            Rule subRule = Rule.fromKey((String)kv.getKey());
            result.put(subRule.getKey(), TemplateHandler.handle(subRule, kv.getValue()));
            if (subRule.getStep() != null && value.get(kv.getKey()) instanceof Number) {
                value.put((String)kv.getKey(), (Object)NumberUtils.compute((Number)value.get(kv.getKey()), subRule.getStep(), NumberUtils.Operation.add));
            }
        });
        return result;
    }

    public static Object handle(Rule rule, JSONArray value) {
        if (value.isEmpty()) {
            return value;
        }
        if (Long.valueOf(1L).equals(rule.getMin()) && rule.getMax() == null) {
            return TemplateHandler.handle(value.get((int)BasicFunction.integer(0L, value.size() - 1)));
        }
        if (Integer.valueOf(1).equals(rule.getStep())) {
            return TemplateHandler.handle(value.get(0));
        }
        if (rule.isRange()) {
            JSONArray result = new JSONArray();
            int i = 0;
            while ((long)i < rule.getCount()) {
                result.addAll((Collection)TemplateHandler.handle(value));
                ++i;
            }
            return result;
        }
        return value;
    }

    public static JSONArray handle(JSONArray value) {
        JSONArray result = new JSONArray();
        value.stream().forEach(json -> result.add(TemplateHandler.handle(json)));
        return result;
    }

    public static JSONObject sortedTemplate(JSONObject template, List<String> sortedKeys) {
        Map<String, Integer> sortDict = IntStream.range(0, sortedKeys.size()).mapToObj(i -> new Object[]{i, sortedKeys.get(i)}).collect(Collectors.toMap(array -> (String)array[1], array -> (int)((Integer)array[0])));
        template.entrySet().removeIf(entry -> !sortDict.containsKey(Rule.fromKey((String)entry.getKey()).getKey()));
        Map sortedMap = template.entrySet().stream().sorted((e1, e2) -> {
            Rule subRule1 = Rule.fromKey((String)e1.getKey());
            Rule subRule2 = Rule.fromKey((String)e2.getKey());
            return (Integer)sortDict.get(subRule1.getKey()) - (Integer)sortDict.get(subRule2.getKey());
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldVal, newVal) -> oldVal, LinkedHashMap::new));
        return new JSONObject(sortedMap);
    }
}

