/*
 * Decompiled with CFR 0.152.
 */
package com.luckypeng.mock.core.util;

public class NumberUtils {
    private NumberUtils() {
    }

    public static Integer parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Long parseLong(String s) {
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Number compute(Number n1, Number n2, Operation operation) {
        Double d1 = null;
        Double d2 = null;
        Long g1 = null;
        Long g2 = null;
        if (n1 instanceof Double || n1 instanceof Float) {
            d1 = n1.doubleValue();
        } else {
            g1 = n1.longValue();
        }
        if (n2 instanceof Double || n2 instanceof Float) {
            d2 = n2.doubleValue();
        } else {
            g2 = n2.longValue();
        }
        if (d1 != null) {
            if (d2 != null) {
                return NumberUtils.compute(d1, d2, operation);
            }
            return NumberUtils.compute(d1, g2, operation);
        }
        if (d2 != null) {
            return NumberUtils.compute(g1, d2, operation);
        }
        return NumberUtils.compute(g1, g2, operation);
    }

    private static Number compute(Double n1, Double n2, Operation operation) {
        switch (operation) {
            case add: {
                return n1 + n2;
            }
            case subtract: {
                return n1 - n2;
            }
            case multiply: {
                return n1 * n2;
            }
            case divide: {
                return n1 / n2;
            }
        }
        throw new RuntimeException("\u4e0d\u652f\u6301 Double \u4e0e Double \u4e4b\u95f4\u7684\u8be5\u8fd0\u7b97: " + (Object)((Object)operation));
    }

    private static Number compute(Long n1, Double n2, Operation operation) {
        switch (operation) {
            case add: {
                return (double)n1.longValue() + n2;
            }
            case subtract: {
                return (double)n1.longValue() - n2;
            }
            case multiply: {
                return (double)n1.longValue() * n2;
            }
            case divide: {
                return (double)n1.longValue() / n2;
            }
        }
        throw new RuntimeException("\u4e0d\u652f\u6301 Long \u4e0e Double \u4e4b\u95f4\u7684\u8be5\u8fd0\u7b97: " + (Object)((Object)operation));
    }

    private static Number compute(Double n1, Long n2, Operation operation) {
        switch (operation) {
            case add: {
                return n1 + (double)n2.longValue();
            }
            case subtract: {
                return n1 - (double)n2.longValue();
            }
            case multiply: {
                return n1 * (double)n2.longValue();
            }
            case divide: {
                return n1 / (double)n2.longValue();
            }
        }
        throw new RuntimeException("\u4e0d\u652f\u6301 Double \u4e0e Long \u4e4b\u95f4\u7684\u8be5\u8fd0\u7b97: " + (Object)((Object)operation));
    }

    private static Number compute(Long n1, Long n2, Operation operation) {
        switch (operation) {
            case add: {
                return n1 + n2;
            }
            case subtract: {
                return n1 - n2;
            }
            case multiply: {
                return n1 * n2;
            }
            case divide: {
                return n1 / n2;
            }
        }
        throw new RuntimeException("\u4e0d\u652f\u6301 Long \u4e0e Long \u4e4b\u95f4\u7684\u8be5\u8fd0\u7b97: " + (Object)((Object)operation));
    }

    public static enum Operation {
        add,
        subtract,
        multiply,
        divide;

    }
}

