package com.m2f.archer

import app.cash.sqldelight.Query
import app.cash.sqldelight.SuspendingTransacterImpl
import app.cash.sqldelight.db.QueryResult
import app.cash.sqldelight.db.SqlCursor
import app.cash.sqldelight.db.SqlDriver
import kotlin.Any
import kotlin.Long
import kotlin.String

public class ExpirationRegistryQueries(
  driver: SqlDriver,
) : SuspendingTransacterImpl(driver) {
  public fun <T : Any> getInstant(
    key: String,
    hash: Long,
    mapper: (
      key: String,
      hash: Long,
      name: String,
      instant: String,
      whenCreated: String,
    ) -> T,
  ): Query<T> = GetInstantQuery(key, hash) { cursor ->
    mapper(
      cursor.getString(0)!!,
      cursor.getLong(1)!!,
      cursor.getString(2)!!,
      cursor.getString(3)!!,
      cursor.getString(4)!!
    )
  }

  public fun getInstant(key: String, hash: Long): Query<ExpirationRegistry> = getInstant(key,
      hash) { key_, hash_, name, instant, whenCreated ->
    ExpirationRegistry(
      key_,
      hash_,
      name,
      instant,
      whenCreated
    )
  }

  public suspend fun insertInstant(
    key: String,
    hash: Long,
    name: String,
    instant: String,
    whenCreated: String,
  ) {
    driver.execute(657_443_409, """
        |INSERT OR REPLACE INTO ExpirationRegistry(key, hash, name, instant, whenCreated)
        |VALUES (?, ?, ?, ?, ?)
        """.trimMargin(), 5) {
          bindString(0, key)
          bindLong(1, hash)
          bindString(2, name)
          bindString(3, instant)
          bindString(4, whenCreated)
        }.await()
    notifyQueries(657_443_409) { emit ->
      emit("ExpirationRegistry")
    }
  }

  public suspend fun deleteInstant(key: String, hash: Long) {
    driver.execute(964_178_719, """DELETE FROM ExpirationRegistry WHERE key = ? AND hash = ?""", 2)
        {
          bindString(0, key)
          bindLong(1, hash)
        }.await()
    notifyQueries(964_178_719) { emit ->
      emit("ExpirationRegistry")
    }
  }

  private inner class GetInstantQuery<out T : Any>(
    public val key: String,
    public val hash: Long,
    mapper: (SqlCursor) -> T,
  ) : Query<T>(mapper) {
    override fun addListener(listener: Query.Listener) {
      driver.addListener("ExpirationRegistry", listener = listener)
    }

    override fun removeListener(listener: Query.Listener) {
      driver.removeListener("ExpirationRegistry", listener = listener)
    }

    override fun <R> execute(mapper: (SqlCursor) -> QueryResult<R>): QueryResult<R> =
        driver.executeQuery(-278_830_878,
        """SELECT * FROM ExpirationRegistry WHERE key = ? AND hash = ?""", mapper, 2) {
      bindString(0, key)
      bindLong(1, hash)
    }

    override fun toString(): String = "ExpirationRegistry.sq:getInstant"
  }
}
