package com.m2f.archer.sqldelight

import app.cash.sqldelight.SuspendingTransacter
import app.cash.sqldelight.db.QueryResult
import app.cash.sqldelight.db.SqlDriver
import app.cash.sqldelight.db.SqlSchema
import com.m2f.archer.ExpirationRegistryQueries
import com.m2f.archer.sqldelight.database.newInstance
import com.m2f.archer.sqldelight.database.schema
import kotlin.Unit

public interface CacheExpirationDatabase : SuspendingTransacter {
  public val expirationRegistryQueries: ExpirationRegistryQueries

  public companion object {
    public val Schema: SqlSchema<QueryResult.AsyncValue<Unit>>
      get() = CacheExpirationDatabase::class.schema

    public operator fun invoke(driver: SqlDriver): CacheExpirationDatabase =
        CacheExpirationDatabase::class.newInstance(driver)
  }
}
