package com.m2f.archer.sqldelight.database

import app.cash.sqldelight.SuspendingTransacterImpl
import app.cash.sqldelight.db.AfterVersion
import app.cash.sqldelight.db.QueryResult
import app.cash.sqldelight.db.SqlDriver
import app.cash.sqldelight.db.SqlSchema
import com.m2f.archer.ExpirationRegistryQueries
import com.m2f.archer.sqldelight.CacheExpirationDatabase
import kotlin.Long
import kotlin.Unit
import kotlin.reflect.KClass

internal val KClass<CacheExpirationDatabase>.schema: SqlSchema<QueryResult.AsyncValue<Unit>>
  get() = CacheExpirationDatabaseImpl.Schema

internal fun KClass<CacheExpirationDatabase>.newInstance(driver: SqlDriver): CacheExpirationDatabase
    = CacheExpirationDatabaseImpl(driver)

private class CacheExpirationDatabaseImpl(
  driver: SqlDriver,
) : SuspendingTransacterImpl(driver), CacheExpirationDatabase {
  override val expirationRegistryQueries: ExpirationRegistryQueries =
      ExpirationRegistryQueries(driver)

  public object Schema : SqlSchema<QueryResult.AsyncValue<Unit>> {
    override val version: Long
      get() = 1

    override fun create(driver: SqlDriver): QueryResult.AsyncValue<Unit> = QueryResult.AsyncValue {
      driver.execute(null, """
          |CREATE TABLE ExpirationRegistry (
          |    key TEXT NOT NULL,
          |    hash INTEGER NOT NULL,
          |    name TEXT NOT NULL,
          |    instant TEXT NOT NULL,
          |    whenCreated TEXT NOT NULL,
          |    PRIMARY KEY(key, hash)
          |)
          """.trimMargin(), 0).await()
    }

    override fun migrate(
      driver: SqlDriver,
      oldVersion: Long,
      newVersion: Long,
      vararg callbacks: AfterVersion,
    ): QueryResult.AsyncValue<Unit> = QueryResult.AsyncValue {
    }
  }
}
