/*
 * Decompiled with CFR 0.152.
 */
package com.mailersend.sdk;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mailersend.sdk.MailerSendResponse;
import com.mailersend.sdk.MailerSendStringResponse;
import com.mailersend.sdk.exceptions.JsonResponseError;
import com.mailersend.sdk.exceptions.MailerSendException;
import com.mailersend.sdk.util.JsonSerializationDeserializationStrategy;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;

public class MailerSendApi {
    private final String endpointBase = "https://api.mailersend.com/v1";
    private String apiToken = "";
    private HttpClient client = HttpClient.newHttpClient();

    public void setToken(String token) {
        this.apiToken = token;
    }

    public <T extends MailerSendResponse> T getRequest(String endpoint, Class<T> responseClass) throws MailerSendException {
        HttpRequest request = HttpRequest.newBuilder(URI.create(this.endpointBase.concat(endpoint))).header("Content-type", "applicateion/json").header("Authorization", "Bearer ".concat(this.apiToken)).GET().build();
        HttpResponse<String> responseObject = null;
        try {
            responseObject = this.client.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException | InterruptedException e) {
            MailerSendException ex = (MailerSendException)e;
            throw ex;
        }
        if (responseClass == MailerSendStringResponse.class) {
            MailerSendStringResponse response = new MailerSendStringResponse();
            response.responseString = responseObject.body().toString();
            return (T)response;
        }
        return this.handleApiResponse(responseObject, responseClass);
    }

    public <T extends MailerSendResponse> T postRequest(String endpoint, String requestBody, Class<T> responseClass) throws MailerSendException {
        HttpRequest request = HttpRequest.newBuilder(URI.create(this.endpointBase.concat(endpoint))).header("Content-type", "applicateion/json").header("Authorization", "Bearer ".concat(this.apiToken)).POST(HttpRequest.BodyPublishers.ofString(requestBody)).build();
        HttpResponse<String> responseObject = null;
        try {
            responseObject = this.client.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException | InterruptedException e) {
            MailerSendException ex = (MailerSendException)e;
            throw ex;
        }
        return this.handleApiResponse(responseObject, responseClass);
    }

    public <T extends MailerSendResponse> T deleteRequest(String endpoint, Class<T> responseClass) throws MailerSendException {
        HttpRequest request = HttpRequest.newBuilder(URI.create(this.endpointBase.concat(endpoint))).header("Content-type", "applicateion/json").header("Authorization", "Bearer ".concat(this.apiToken)).DELETE().build();
        HttpResponse<String> responseObject = null;
        try {
            responseObject = this.client.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException | InterruptedException e) {
            MailerSendException ex = (MailerSendException)e;
            throw ex;
        }
        return this.handleApiResponse(responseObject, responseClass);
    }

    public <T extends MailerSendResponse> T deleteRequest(String endpoint, String requestBody, Class<T> responseClass) throws MailerSendException {
        HttpRequest request = HttpRequest.newBuilder(URI.create(this.endpointBase.concat(endpoint))).header("Content-type", "applicateion/json").header("Authorization", "Bearer ".concat(this.apiToken)).method("DELETE", HttpRequest.BodyPublishers.ofString(requestBody)).build();
        HttpResponse<String> responseObject = null;
        try {
            responseObject = this.client.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException | InterruptedException e) {
            MailerSendException ex = (MailerSendException)e;
            throw ex;
        }
        return this.handleApiResponse(responseObject, responseClass);
    }

    public <T extends MailerSendResponse> T putRequest(String endpoint, String requestBody, Class<T> responseClass) throws MailerSendException {
        HttpRequest request = HttpRequest.newBuilder(URI.create(this.endpointBase.concat(endpoint))).header("Content-type", "applicateion/json").header("Authorization", "Bearer ".concat(this.apiToken)).PUT(HttpRequest.BodyPublishers.ofString(requestBody)).build();
        HttpResponse<String> responseObject = null;
        try {
            responseObject = this.client.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException | InterruptedException e) {
            MailerSendException ex = (MailerSendException)e;
            throw ex;
        }
        return this.handleApiResponse(responseObject, responseClass);
    }

    private <T extends MailerSendResponse> T handleApiResponse(HttpResponse<String> responseObject, Class<T> responseClass) throws MailerSendException {
        String stringResponse = "";
        Gson gson = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new JsonSerializationDeserializationStrategy(false)).addDeserializationExclusionStrategy((ExclusionStrategy)new JsonSerializationDeserializationStrategy(true)).create();
        int[] successCodes = new int[]{200, 201, 202, 204};
        boolean isSuccess = false;
        for (int code : successCodes) {
            if (code != responseObject.statusCode()) continue;
            isSuccess = true;
            break;
        }
        if (responseObject != null && !isSuccess) {
            stringResponse = responseObject.body().toString();
            JsonResponseError error = (JsonResponseError)gson.fromJson(stringResponse, JsonResponseError.class);
            MailerSendException responseError = new MailerSendException(error.message);
            responseError.errors = error.errors;
            responseError.code = responseObject.statusCode();
            throw responseError;
        }
        stringResponse = responseObject.body().toString();
        MailerSendResponse response = null;
        if (!stringResponse.equals("") && !stringResponse.equals("[]")) {
            response = (MailerSendResponse)gson.fromJson(stringResponse, responseClass);
        } else {
            try {
                response = (MailerSendResponse)responseClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                MailerSendException ex = (MailerSendException)e;
                throw ex;
            }
        }
        try {
            response.messageId = responseObject.headers().firstValue("x-message-id").get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            response.rateLimit = Integer.parseInt(responseObject.headers().firstValue("x-ratelimit-limit").get());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            response.rateLimitRemaining = Integer.parseInt(responseObject.headers().firstValue("x-ratelimit-remaining").get());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        response.responseStatusCode = responseObject.statusCode();
        return (T)response;
    }
}

