/*
 * Decompiled with CFR 0.152.
 */
package com.mailersend.sdk.domains;

import com.google.gson.annotations.SerializedName;
import com.mailersend.sdk.MailerSendResponse;
import com.mailersend.sdk.domains.DomainSettings;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;

public class Domain
extends MailerSendResponse {
    @SerializedName(value="id")
    public String id;
    @SerializedName(value="name")
    public String name;
    @SerializedName(value="dkim")
    public boolean dkim;
    @SerializedName(value="spf")
    public boolean spf;
    @SerializedName(value="tracking")
    public boolean tracking;
    @SerializedName(value="is_verified")
    public boolean isVerified;
    @SerializedName(value="is_cname_verified")
    public boolean isCnameVerified;
    @SerializedName(value="is_dns_active")
    public boolean isDnsActive;
    @SerializedName(value="is_cname_active")
    public boolean isCnameActive;
    @SerializedName(value="is_tracking_allowed")
    public boolean isTrackingAllowed;
    @SerializedName(value="has_not_queued_messaged")
    public boolean hasNotQueuedMessaged;
    @SerializedName(value="not_queued_messages_count")
    public int notQueuedMessagesCount;
    @SerializedName(value="domain_settings")
    public DomainSettings domainSettings;
    @SerializedName(value="created_at")
    private String createdAtStr;
    @SerializedName(value="updated_at")
    private String updatedAtStr;
    public Date createdAt;
    public Date updatedAt;

    public void postDeserialize() {
        this.parseDates();
    }

    private void parseDates() {
        Instant instant;
        TemporalAccessor ta;
        if (this.createdAtStr != null && !this.createdAtStr.isBlank()) {
            ta = DateTimeFormatter.ISO_INSTANT.parse(this.createdAtStr);
            instant = Instant.from(ta);
            this.createdAt = Date.from(instant);
        }
        if (this.updatedAtStr != null && !this.updatedAtStr.isBlank()) {
            ta = DateTimeFormatter.ISO_INSTANT.parse(this.updatedAtStr);
            instant = Instant.from(ta);
            this.updatedAt = Date.from(instant);
        }
    }
}

