/*
 * Decompiled with CFR 0.152.
 */
package com.mailersend.sdk.emails;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mailersend.sdk.MailerSend;
import com.mailersend.sdk.MailerSendApi;
import com.mailersend.sdk.MailerSendResponse;
import com.mailersend.sdk.MailerSendStringResponse;
import com.mailersend.sdk.Recipient;
import com.mailersend.sdk.emails.BulkSendStatus;
import com.mailersend.sdk.emails.Email;
import com.mailersend.sdk.emails.SendBulkResponse;
import com.mailersend.sdk.exceptions.MailerSendException;
import com.mailersend.sdk.util.JsonSerializationDeserializationStrategy;
import java.lang.reflect.Type;
import java.util.ArrayList;

public class Emails {
    private MailerSend apiObjectReference;
    private Recipient defaultFrom = null;

    public Emails(MailerSend objectRef) {
        this.apiObjectReference = objectRef;
    }

    public void setDefaultFrom(Recipient from) {
        this.defaultFrom = from;
    }

    public Email createEmail() {
        Email newEmail = new Email();
        newEmail.from = this.defaultFrom;
        return newEmail;
    }

    public MailerSendResponse send(Email email) throws MailerSendException {
        String json = email.serializeForSending();
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        MailerSendResponse response = api.postRequest("/email", json, MailerSendResponse.class);
        return response;
    }

    public String bulkSend(Email[] emails) throws MailerSendException {
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        for (Email email : emails) {
            email.preparePersonalizationForAllRecipients();
            email.prepareSubstitutionsForAllRecipients();
        }
        Gson gson = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new JsonSerializationDeserializationStrategy(false)).addDeserializationExclusionStrategy((ExclusionStrategy)new JsonSerializationDeserializationStrategy(true)).create();
        String json = gson.toJson((Object)emails);
        SendBulkResponse response = api.postRequest("/bulk-email", json, SendBulkResponse.class);
        return response.bulkSendId;
    }

    public BulkSendStatus bulkSendStatus(String bulkSendId) throws MailerSendException {
        String endpoint = "/bulk-email/".concat(bulkSendId);
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        MailerSendStringResponse response = api.getRequest(endpoint, MailerSendStringResponse.class);
        JsonDeserializer<BulkSendStatus> deserializer = new JsonDeserializer<BulkSendStatus>(){

            public BulkSendStatus deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonElement suppressedRecipientsEl;
                JsonObject jsonObject = json.getAsJsonObject();
                JsonObject data = jsonObject.get("data").getAsJsonObject();
                BulkSendStatus newStatus = new BulkSendStatus();
                newStatus.id = data.get("id").getAsString();
                newStatus.state = data.get("state").getAsString();
                newStatus.totalRecipientsCount = data.get("total_recipients_count").getAsInt();
                newStatus.suppressedRecipientsCount = data.get("suppressed_recipients_count").getAsInt();
                newStatus.validationErrorsCount = data.get("validation_errors_count").getAsInt();
                ArrayList<String> messagesIdsList = new ArrayList<String>();
                if (!data.get("messages_id").isJsonNull()) {
                    JsonArray messagesIds = data.get("messages_id").getAsJsonArray();
                    for (JsonElement messageId : messagesIds) {
                        messagesIdsList.add(messageId.getAsString());
                    }
                }
                newStatus.messagesId = messagesIdsList.toArray(new String[0]);
                newStatus.createdAtString = data.get("created_at").getAsString();
                newStatus.updatedAtString = data.get("updated_at").getAsString();
                JsonElement validationErrorsEl = data.get("validataion_errors");
                if (validationErrorsEl != null) {
                    newStatus.validationErrors = validationErrorsEl.getAsJsonObject();
                }
                if ((suppressedRecipientsEl = data.get("suppressed_recipients")) != null && !suppressedRecipientsEl.isJsonNull()) {
                    newStatus.suppressedRecipients = suppressedRecipientsEl.getAsJsonObject();
                }
                return newStatus;
            }
        };
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(BulkSendStatus.class, (Object)deserializer);
        Gson customGson = gsonBuilder.create();
        BulkSendStatus status = (BulkSendStatus)customGson.fromJson(response.responseString, BulkSendStatus.class);
        status.parseDates();
        return status;
    }
}

