/*
 * Decompiled with CFR 0.152.
 */
package com.mailersend.sdk.recipients;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mailersend.sdk.MailerSend;
import com.mailersend.sdk.MailerSendApi;
import com.mailersend.sdk.MailerSendResponse;
import com.mailersend.sdk.exceptions.MailerSendException;
import com.mailersend.sdk.recipients.BlocklistListResponse;
import com.mailersend.sdk.recipients.SuppressionAddBuilder;
import com.mailersend.sdk.recipients.SuppressionList;
import com.mailersend.sdk.util.JsonSerializationDeserializationStrategy;
import java.util.ArrayList;

public class Suppressions {
    private MailerSend apiObjectReference;
    private int pageFilter = 1;
    private int limitFilter = 25;
    private String domainIdFilter = null;
    private SuppressionAddBuilder addBuilder;

    public Suppressions(MailerSend ref) {
        this.apiObjectReference = ref;
        this.addBuilder = new SuppressionAddBuilder(ref);
    }

    public SuppressionAddBuilder addBuilder() {
        return this.addBuilder;
    }

    public Suppressions page(int page) {
        this.pageFilter = page;
        return this;
    }

    public Suppressions limit(int limit) {
        this.limitFilter = limit;
        return this;
    }

    public Suppressions domainId(String domainId) {
        this.domainIdFilter = domainId;
        return this;
    }

    public BlocklistListResponse getBlocklist() throws MailerSendException {
        String endpoint = "/suppressions/blocklist".concat(this.prepareParamsUrl());
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        BlocklistListResponse response = api.getRequest(endpoint, BlocklistListResponse.class);
        return response;
    }

    public SuppressionList getHardBounces() throws MailerSendException {
        String endpoint = "/suppressions/hard-bounces".concat(this.prepareParamsUrl());
        return this.getSuppressionList(endpoint);
    }

    public SuppressionList getSpamComplaints() throws MailerSendException {
        String endpoint = "/suppressions/spam-complaints".concat(this.prepareParamsUrl());
        return this.getSuppressionList(endpoint);
    }

    public SuppressionList getUnsubscribes() throws MailerSendException {
        String endpoint = "/suppressions/unsubscribes".concat(this.prepareParamsUrl());
        return this.getSuppressionList(endpoint);
    }

    private SuppressionList getSuppressionList(String endpoint) throws MailerSendException {
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        SuppressionList response = api.getRequest(endpoint, SuppressionList.class);
        return response;
    }

    public MailerSendResponse deleteBlocklistItems(String[] ids) throws MailerSendException {
        return this.deleteSuppressionListItems("/suppressions/blocklist", ids);
    }

    public MailerSendResponse deleteBlocklistAllItems() throws MailerSendException {
        return this.deleteSuppressionListAllItems("/suppressions/blocklist");
    }

    public MailerSendResponse deleteHardBouncesItems(String[] ids) throws MailerSendException {
        return this.deleteSuppressionListItems("/suppressions/hard-bounces", ids);
    }

    public MailerSendResponse deleteHardBouncesAllItems() throws MailerSendException {
        return this.deleteSuppressionListAllItems("/suppressions/hard-bounces");
    }

    public MailerSendResponse deleteSpamComplaintsItems(String[] ids) throws MailerSendException {
        return this.deleteSuppressionListItems("/suppressions/spam-complaints", ids);
    }

    public MailerSendResponse deleteSpamComplaintsAllItems() throws MailerSendException {
        return this.deleteSuppressionListAllItems("/suppressions/spam-complaints");
    }

    public MailerSendResponse deleteUnsubscribesItems(String[] ids) throws MailerSendException {
        return this.deleteSuppressionListItems("/suppressions/unsubscribres", ids);
    }

    public MailerSendResponse deleteUnsubscribesAllItems() throws MailerSendException {
        return this.deleteSuppressionListAllItems("/suppressions/unsubscribes");
    }

    private MailerSendResponse deleteSuppressionListItems(String endpoint, String[] ids) throws MailerSendException {
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        Gson gson = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new JsonSerializationDeserializationStrategy(false)).addDeserializationExclusionStrategy((ExclusionStrategy)new JsonSerializationDeserializationStrategy(true)).create();
        String requestBody = gson.toJson((Object)ids);
        requestBody = "{\"ids\":".concat(requestBody);
        if (this.domainIdFilter != null) {
            requestBody = requestBody.concat(",\"domain_id\":\"".concat(this.domainIdFilter).concat("\""));
        }
        requestBody = requestBody.concat("}");
        MailerSendResponse response = api.deleteRequest(endpoint, requestBody, MailerSendResponse.class);
        return response;
    }

    private MailerSendResponse deleteSuppressionListAllItems(String endpoint) throws MailerSendException {
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        String requestBody = "{\"all\":true";
        if (this.domainIdFilter != null) {
            requestBody = requestBody.concat(",\"domain_id\":\"".concat(this.domainIdFilter).concat("\""));
        }
        requestBody = requestBody.concat("}");
        MailerSendResponse response = api.deleteRequest(endpoint, requestBody, MailerSendResponse.class);
        return response;
    }

    private String prepareParamsUrl() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("page=".concat(String.valueOf(this.pageFilter)));
        params.add("limit=".concat(String.valueOf(this.limitFilter)));
        if (this.domainIdFilter != null) {
            params.add("domain_id=".concat(this.domainIdFilter));
        }
        String requestParams = "";
        for (int i = 0; i < params.size(); ++i) {
            String attrSep = "&";
            if (i == 0) {
                attrSep = "?";
            }
            requestParams = requestParams.concat(attrSep).concat((String)params.get(i));
        }
        return requestParams;
    }
}

