/*
 * Decompiled with CFR 0.152.
 */
package com.mailersend.sdk.activities;

import com.mailersend.sdk.MailerSend;
import com.mailersend.sdk.MailerSendApi;
import com.mailersend.sdk.activities.ActivitiesList;
import com.mailersend.sdk.exceptions.MailerSendException;
import java.util.ArrayList;
import java.util.Date;

public class Activities {
    private MailerSend apiObjectReference;

    public Activities(MailerSend apiReference) {
        this.apiObjectReference = apiReference;
    }

    public ActivitiesList getActivities(String domainId) throws MailerSendException {
        return this.getActivities(domainId, 1, 25, null, null, null);
    }

    public ActivitiesList getActivities(String domainId, int page, int limit, Date dateFrom, Date dateTo, String[] events) throws MailerSendException {
        String endpoint = "/activity/".concat(domainId);
        ArrayList<String> params = new ArrayList<String>();
        if (page > -1) {
            params.add("page=".concat(String.valueOf(page)));
        }
        if (limit > -1) {
            params.add("limit=".concat(String.valueOf(limit)));
        }
        if (dateFrom != null && dateTo != null && !dateTo.after(dateFrom)) {
            throw new MailerSendException("From date cannot be after to date.");
        }
        if (dateFrom != null) {
            params.add("date_from=".concat(String.valueOf(dateFrom.getTime() / 1000L)));
        }
        if (dateTo != null) {
            params.add("date_to=".concat(String.valueOf(dateTo.getTime() / 1000L)));
        }
        if (events != null) {
            String eventsParam = "";
            for (int i = 0; i < events.length; ++i) {
                if (i > 0) {
                    eventsParam = eventsParam.concat("&");
                }
                eventsParam = eventsParam.concat("event[]=").concat(events[i]);
            }
            params.add(eventsParam);
        }
        for (int i = 0; i < params.size(); ++i) {
            String attrSep = "&";
            if (i == 0) {
                attrSep = "?";
            }
            endpoint = endpoint.concat(attrSep).concat((String)params.get(i));
        }
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        ActivitiesList activities = api.getRequest(endpoint, ActivitiesList.class);
        activities.postDeserialize();
        activities.mailersendObj = this.apiObjectReference;
        activities.domainId = domainId;
        activities.dateFrom = dateFrom;
        activities.dateTo = dateTo;
        activities.events = events;
        return activities;
    }
}

