/*
 * Decompiled with CFR 0.152.
 */
package com.mailsend.sdk.emailverification;

import com.mailersend.sdk.MailerSend;
import com.mailersend.sdk.MailerSendApi;
import com.mailersend.sdk.exceptions.MailerSendException;
import com.mailsend.sdk.emailverification.EmailVerificationBuilder;
import com.mailsend.sdk.emailverification.EmailVerificationList;
import com.mailsend.sdk.emailverification.EmailVerificationLists;
import com.mailsend.sdk.emailverification.ListVerificationResults;
import com.mailsend.sdk.emailverification.SingleEmailVerificationListResponse;
import java.util.ArrayList;

public class EmailVerification {
    private MailerSend apiObjectReference;
    private int pageFilter = 1;
    private int limitFilter = 25;
    private EmailVerificationBuilder builder;

    public EmailVerification(MailerSend ref) {
        this.apiObjectReference = ref;
        this.builder = new EmailVerificationBuilder(ref);
    }

    public EmailVerification page(int page) {
        this.pageFilter = page;
        return this;
    }

    public EmailVerification limit(int limit) {
        this.limitFilter = limit;
        return this;
    }

    public EmailVerificationBuilder builder() {
        return this.builder;
    }

    public EmailVerificationBuilder newBuilder() {
        return new EmailVerificationBuilder(this.apiObjectReference);
    }

    public EmailVerificationLists getLists() throws MailerSendException {
        String endpoint = "/email-verification".concat(this.prepareParamsUrl());
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        EmailVerificationLists lists = api.getRequest(endpoint, EmailVerificationLists.class);
        for (EmailVerificationList l : lists.lists) {
            l.postDeserialize();
        }
        return lists;
    }

    public EmailVerificationList getList(String emailVerificationId) throws MailerSendException {
        String endpoint = "/email-verification/".concat(emailVerificationId);
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        SingleEmailVerificationListResponse response = api.getRequest(endpoint, SingleEmailVerificationListResponse.class);
        response.list.postDeserialize();
        return response.list;
    }

    public EmailVerificationList verifyList(String listId) throws MailerSendException {
        String endpoint = "/email-verification/".concat(listId).concat("/verify");
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        SingleEmailVerificationListResponse response = api.getRequest(endpoint, SingleEmailVerificationListResponse.class);
        response.list.postDeserialize();
        return response.list;
    }

    public ListVerificationResults verificationResults(String listId) throws MailerSendException {
        String endpoint = "/email-verification/".concat(listId).concat("/results");
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        ListVerificationResults response = api.getRequest(endpoint, ListVerificationResults.class);
        return response;
    }

    private String prepareParamsUrl() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("page=".concat(String.valueOf(this.pageFilter)));
        params.add("limit=".concat(String.valueOf(this.limitFilter)));
        String requestParams = "";
        for (int i = 0; i < params.size(); ++i) {
            String attrSep = "&";
            if (i == 0) {
                attrSep = "?";
            }
            requestParams = requestParams.concat(attrSep).concat((String)params.get(i));
        }
        return requestParams;
    }
}

