/*
 * Decompiled with CFR 0.152.
 */
package com.mailsend.sdk.emailverification;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mailersend.sdk.MailerSend;
import com.mailersend.sdk.MailerSendApi;
import com.mailersend.sdk.exceptions.MailerSendException;
import com.mailersend.sdk.util.JsonSerializationDeserializationStrategy;
import com.mailsend.sdk.emailverification.EmailVerificationBuilderBody;
import com.mailsend.sdk.emailverification.EmailVerificationList;
import com.mailsend.sdk.emailverification.SingleEmailVerificationListResponse;
import java.util.ArrayList;
import java.util.Arrays;

public class EmailVerificationBuilder {
    private EmailVerificationBuilderBody builderBody;
    private MailerSend apiObjectReference;
    private ArrayList<String> emails = new ArrayList();

    public EmailVerificationBuilder(MailerSend ref) {
        this.apiObjectReference = ref;
        this.builderBody = new EmailVerificationBuilderBody();
    }

    public EmailVerificationBuilder name(String name) {
        this.builderBody.name = name;
        return this;
    }

    public EmailVerificationBuilder addEmail(String email) {
        this.emails.add(email);
        return this;
    }

    public EmailVerificationBuilder addEmails(String[] emails) {
        this.emails.addAll(Arrays.asList(emails));
        return this;
    }

    public EmailVerificationList create() throws MailerSendException {
        String endpoint = "/email-verification";
        String[] em = new String[this.emails.size()];
        em = this.emails.toArray(em);
        this.builderBody.emails = em;
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        Gson gson = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new JsonSerializationDeserializationStrategy(false)).addDeserializationExclusionStrategy((ExclusionStrategy)new JsonSerializationDeserializationStrategy(true)).create();
        String json = gson.toJson((Object)this.builderBody);
        this.builderBody.reset();
        SingleEmailVerificationListResponse response = api.postRequest(endpoint, json, SingleEmailVerificationListResponse.class);
        return response.list;
    }
}

