/*************************************************
 * MailerSend Java SDK
 * https://github.com/mailersend/mailersend-java
 * 
 * @author MailerSend <support@mailersend.com>
 * https://mailersend.com
 **************************************************/
package com.mailersend.sdk.templates;

import com.google.gson.annotations.SerializedName;
import com.mailersend.sdk.util.PaginatedResponse;

/**
 * <p>TemplatesList class.</p>
 *
 * @author mailersend
 * @version $Id: $Id
 */
public class TemplatesList extends PaginatedResponse {

    @SerializedName("data")
    public TemplateItem[] templates;
    
    /**
     * Is called to perform any actions after the deserialization of the response
     * Do not call directly
     */
    protected void postDeserialize() {
        
        for (TemplateItem item : templates) {
            
            item.postDeserialize();
        }
    }
}
