/*
 * Decompiled with CFR 0.152.
 */
package com.mailersend.sdk.scheduledmessages;

import com.google.gson.annotations.SerializedName;
import com.mailersend.sdk.scheduledmessages.Domain;
import com.mailersend.sdk.scheduledmessages.Message;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;

public class ScheduledMessage {
    @SerializedName(value="message_id")
    public String messageId;
    @SerializedName(value="subject")
    public String subject;
    @SerializedName(value="send_at")
    private String sendAtStr;
    public Date sendAt;
    @SerializedName(value="status")
    public String status;
    @SerializedName(value="status_message")
    public String statusMessage;
    @SerializedName(value="created_at")
    private String createdAtStr;
    public Date createdAt;
    @SerializedName(value="message")
    public Message message;
    @SerializedName(value="domain")
    public Domain domain;

    public void postDeserialize() {
        this.parseDates();
        if (this.message != null) {
            this.message.postDeserialize();
        }
        if (this.domain != null) {
            this.domain.postDeserialize();
        }
    }

    private void parseDates() {
        Instant instant;
        TemporalAccessor ta;
        if (this.createdAtStr != null && !this.createdAtStr.isBlank()) {
            ta = DateTimeFormatter.ISO_INSTANT.parse(this.createdAtStr);
            instant = Instant.from(ta);
            this.createdAt = Date.from(instant);
        }
        if (this.sendAtStr != null && !this.sendAtStr.isBlank()) {
            ta = DateTimeFormatter.ISO_INSTANT.parse(this.sendAtStr);
            instant = Instant.from(ta);
            this.sendAt = Date.from(instant);
        }
    }
}

