/*
 * Decompiled with CFR 0.152.
 */
package com.mailersend.sdk.scheduledmessages;

import com.mailersend.sdk.MailerSend;
import com.mailersend.sdk.MailerSendApi;
import com.mailersend.sdk.MailerSendResponse;
import com.mailersend.sdk.exceptions.MailerSendException;
import com.mailersend.sdk.scheduledmessages.ScheduledMessage;
import com.mailersend.sdk.scheduledmessages.ScheduledMessagesList;
import com.mailersend.sdk.scheduledmessages.SingleScheduledMessageResponse;
import java.util.ArrayList;
import java.util.stream.IntStream;

public class ScheduledMessages {
    private MailerSend apiObjectReference;
    private int pageFilter = 1;
    private int limitFilter = 25;
    private String domainIdFilter;
    private String statusFilter;

    public ScheduledMessages(MailerSend ref) {
        this.apiObjectReference = ref;
    }

    public ScheduledMessages page(int page) {
        this.pageFilter = page;
        return this;
    }

    public ScheduledMessages limit(int limit) {
        this.limitFilter = limit;
        return this;
    }

    public ScheduledMessages domainId(String domainId) {
        this.domainIdFilter = domainId;
        return this;
    }

    public ScheduledMessages status(String status) {
        this.statusFilter = status;
        return this;
    }

    public ScheduledMessagesList getScheduledMessages() throws MailerSendException {
        String endpoint = "/message-schedules".concat(this.prepareParamsUrl());
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        ScheduledMessagesList response = api.getRequest(endpoint, ScheduledMessagesList.class);
        for (ScheduledMessage m : response.scheduledMessages) {
            m.postDeserialize();
        }
        return response;
    }

    public ScheduledMessage getScheduledMessage(String messageId) throws MailerSendException {
        String endpoint = "/message-schedules/".concat(messageId);
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        SingleScheduledMessageResponse response = api.getRequest(endpoint, SingleScheduledMessageResponse.class);
        response.scheduledMessage.postDeserialize();
        return response.scheduledMessage;
    }

    public boolean deleteScheduledMessage(String messageId) throws MailerSendException {
        String endpoint = "/message-schedules/".concat(messageId);
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        MailerSendResponse response = api.deleteRequest(endpoint, MailerSendResponse.class);
        return IntStream.of(200, 204, 202).anyMatch(x -> x == response.responseStatusCode);
    }

    private String prepareParamsUrl() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("page=".concat(String.valueOf(this.pageFilter)));
        params.add("limit=".concat(String.valueOf(this.limitFilter)));
        if (this.domainIdFilter != null) {
            params.add("domain_id=".concat(this.domainIdFilter));
        }
        if (this.statusFilter != null) {
            params.add("status=".concat(this.statusFilter));
        }
        String requestParams = "";
        for (int i = 0; i < params.size(); ++i) {
            String attrSep = "&";
            if (i == 0) {
                attrSep = "?";
            }
            requestParams = requestParams.concat(attrSep).concat((String)params.get(i));
        }
        return requestParams;
    }
}

