/*
 * Decompiled with CFR 0.152.
 */
package com.mailersend.sdk.analytics;

import com.mailersend.sdk.MailerSend;
import com.mailersend.sdk.MailerSendApi;
import com.mailersend.sdk.analytics.AnalyticsByDateList;
import com.mailersend.sdk.analytics.AnalyticsByDateResponse;
import com.mailersend.sdk.analytics.AnalyticsList;
import com.mailersend.sdk.analytics.AnalyticsResponse;
import com.mailersend.sdk.exceptions.MailerSendException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;

public class Analytics {
    private MailerSend apiObjectReference;
    private String domainIdFilter = null;
    private Date dateFromFilter = null;
    private Date dateToFilter = null;
    private ArrayList<String> tagsFilter = new ArrayList();

    public Analytics(MailerSend ref) {
        this.apiObjectReference = ref;
    }

    public Analytics domainId(String domainId) {
        this.domainIdFilter = domainId;
        return this;
    }

    public Analytics dateFrom(Date dateFrom) {
        this.dateFromFilter = dateFrom;
        return this;
    }

    public Analytics dateTo(Date dateTo) {
        this.dateToFilter = dateTo;
        return this;
    }

    public Analytics tags(String[] tags) {
        this.tagsFilter.clear();
        this.tagsFilter.addAll(Arrays.asList(tags));
        return this;
    }

    public Analytics tag(String tag) {
        this.tagsFilter.add(tag);
        return this;
    }

    public AnalyticsByDateList getByDate(String[] events) throws MailerSendException {
        return this.getByDate("group_by=days", events);
    }

    public AnalyticsByDateList getByDate(String groupBy, String[] events) throws MailerSendException {
        if (this.dateFromFilter == null || this.dateToFilter == null) {
            throw new MailerSendException("Date from and Date to dates are required.");
        }
        if (events == null || events.length == 0) {
            throw new MailerSendException("No events passed.");
        }
        String endpoint = "/analytics/date";
        ArrayList<String> params = new ArrayList<String>();
        params.add(groupBy);
        if (events != null) {
            params.add(this.arrayToUrlRequest(events, "event"));
        }
        endpoint = endpoint.concat(this.prepareParamsUrl(params.toArray(new String[0])));
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        AnalyticsByDateResponse msResponse = api.getRequest(endpoint, AnalyticsByDateResponse.class);
        msResponse.postDeserialize();
        return msResponse.response;
    }

    public AnalyticsList getOpensByCountry() throws MailerSendException {
        return this.genericAnalyticsRequest("/analytics/country");
    }

    public AnalyticsList getOpensByUserAgent() throws MailerSendException {
        return this.genericAnalyticsRequest("/analytics/ua-name");
    }

    public AnalyticsList getOpensByUserAgenType() throws MailerSendException {
        return this.genericAnalyticsRequest("/analytics/ua-type");
    }

    private AnalyticsList genericAnalyticsRequest(String requestEndpoint) throws MailerSendException {
        String endpoint = requestEndpoint.concat(this.prepareParamsUrl(null));
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        AnalyticsResponse msResponse = api.getRequest(endpoint, AnalyticsResponse.class);
        msResponse.postDeserialize();
        return msResponse.response;
    }

    private String prepareParamsUrl(String[] additionalParams) {
        ArrayList<String> params = new ArrayList<String>();
        if (additionalParams != null) {
            params.addAll(Arrays.asList(additionalParams));
        }
        if (this.domainIdFilter != null) {
            params.add("domain_id=".concat(this.domainIdFilter));
        }
        if (this.dateFromFilter != null) {
            params.add("date_from=".concat(String.valueOf(this.dateFromFilter.getTime() / 1000L)));
        }
        if (this.dateToFilter != null) {
            params.add("date_to=".concat(String.valueOf(this.dateToFilter.getTime() / 1000L)));
        }
        if (this.tagsFilter.size() > 0) {
            params.add(this.arrayToUrlRequest(this.tagsFilter.toArray(new String[0]), "tags"));
        }
        String requestParams = "";
        for (int i = 0; i < params.size(); ++i) {
            String attrSep = "&";
            if (i == 0) {
                attrSep = "?";
            }
            requestParams = requestParams.concat(attrSep).concat((String)params.get(i));
        }
        return requestParams;
    }

    private String arrayToUrlRequest(String[] values, String field) {
        if (values == null || field == null) {
            return "";
        }
        String params = "";
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                params = params.concat("&");
            }
            params = params.concat(field).concat("[]=").concat(values[i]);
        }
        return params;
    }
}

