/*
 * Decompiled with CFR 0.152.
 */
package com.mailersend.sdk.emails;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mailersend.sdk.Recipient;
import com.mailersend.sdk.emails.Attachment;
import com.mailersend.sdk.emails.Personalization;
import com.mailersend.sdk.util.JsonSerializationDeserializationStrategy;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;

public class Email {
    @SerializedName(value="to")
    public ArrayList<Recipient> recipients = new ArrayList();
    @SerializedName(value="from")
    public Recipient from;
    @SerializedName(value="cc")
    public ArrayList<Recipient> cc = new ArrayList();
    @SerializedName(value="bcc")
    public ArrayList<Recipient> bcc = new ArrayList();
    @SerializedName(value="reply_to")
    public Recipient replyTo;
    @SerializedName(value="subject")
    public String subject;
    @SerializedName(value="text")
    public String text;
    @SerializedName(value="html")
    public String html;
    @SerializedName(value="template_id")
    public String templateId;
    @SerializedName(value="tags")
    public ArrayList<String> tags = new ArrayList();
    public ArrayList<Attachment> attachments = new ArrayList();
    @SerializedName(value="personalization")
    public ArrayList<Personalization> personalization = new ArrayList();
    public Date sendAt;
    protected transient HashMap<String, Object> allRecipientsPersonalization = new HashMap();
    protected transient HashMap<String, String> allRecipientsSubstitutions = new HashMap();
    @SerializedName(value="send_at")
    protected String sendAtStamp;
    @SerializedName(value="in_reply_to")
    public String inReplyTo;

    public void addRecipient(String name, String email) {
        Recipient recipient = new Recipient(name, email);
        this.recipients.add(recipient);
    }

    public void AddRecipient(Recipient recipient) {
        this.recipients.add(recipient);
    }

    public void AddRecipients(Recipient[] recipients) {
        this.recipients.addAll(Arrays.asList(recipients));
    }

    public void AddCc(String name, String email) {
        Recipient recipient = new Recipient(name, email);
        this.cc.add(recipient);
    }

    public void AddCc(Recipient recipient) {
        this.cc.add(recipient);
    }

    public void AddBcc(String name, String email) {
        Recipient recipient = new Recipient(name, email);
        this.bcc.add(recipient);
    }

    public void AddBcc(Recipient recipient) {
        this.bcc.add(recipient);
    }

    public void AddReplyTo(Recipient replyTo) {
        this.replyTo = replyTo;
    }

    public void AddReplyTo(String name, String email) {
        this.replyTo = new Recipient(name, email);
    }

    public void setFrom(String name, String email) {
        Recipient recipient;
        this.from = recipient = new Recipient(name, email);
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setHtml(String html) {
        this.html = html;
    }

    public void setPlain(String plain) {
        this.text = plain;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public void addPersonalization(Recipient recipient, String name, Object value) {
        Personalization personalizationEntry = null;
        for (Personalization p : this.personalization) {
            if (!p.email.equals(recipient.email)) continue;
            personalizationEntry = p;
            break;
        }
        if (personalizationEntry != null) {
            personalizationEntry.data.put(name, value);
        } else {
            personalizationEntry = new Personalization();
            personalizationEntry.email = recipient.email;
            personalizationEntry.data.put(name, value);
            this.personalization.add(personalizationEntry);
        }
    }

    public void setSendAt(Date sendAt) {
        this.sendAt = sendAt;
    }

    public void setInReplyTo(String inReplyTo) {
        this.inReplyTo = inReplyTo;
    }

    public void addPersonalization(String name, Object value) {
        this.allRecipientsPersonalization.put(name, value);
    }

    public void AddVariable(String name, String value) {
        this.allRecipientsSubstitutions.put(name, value);
    }

    public void AddTag(String tag) {
        this.tags.add(tag);
    }

    public void attachFile(String path) throws IOException {
        Attachment attachment = new Attachment();
        attachment.AddAttachmentFromFile(path);
        this.attachments.add(attachment);
    }

    public void attachFile(File file) throws IOException {
        this.attachFile(file.getAbsolutePath());
    }

    protected void preparePersonalizationForAllRecipients() {
        for (Recipient recipient : this.recipients) {
            for (String name : this.allRecipientsPersonalization.keySet()) {
                this.addPersonalization(recipient, name, this.allRecipientsPersonalization.get(name));
            }
        }
    }

    protected void prepareSubstitutionsForAllRecipients() {
        for (Recipient recipient : this.recipients) {
            for (String name : this.allRecipientsSubstitutions.keySet()) {
                this.addPersonalization(recipient, name, this.allRecipientsSubstitutions.get(name));
            }
        }
    }

    public String serializeForSending() {
        this.preparePersonalizationForAllRecipients();
        this.prepareSubstitutionsForAllRecipients();
        if (this.sendAt != null) {
            this.sendAtStamp = String.valueOf(this.sendAt.getTime() / 1000L);
        }
        Gson gson = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new JsonSerializationDeserializationStrategy(false)).addDeserializationExclusionStrategy((ExclusionStrategy)new JsonSerializationDeserializationStrategy(true)).registerTypeAdapter(LocalDate.class, (Object)new LocalDateTypeAdapter().nullSafe()).registerTypeAdapter(Instant.class, (Object)new InstantTypeAdapter().nullSafe()).registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeTypeAdapter().nullSafe()).create();
        String json = gson.toJson((Object)this);
        return json;
    }

    class InstantTypeAdapter
    extends TypeAdapter<Instant> {
        InstantTypeAdapter() {
        }

        public void write(JsonWriter out, Instant value) throws IOException {
            out.value(value.toString());
        }

        public Instant read(JsonReader in) throws IOException {
            return Instant.parse(in.nextString());
        }
    }

    class LocalDateTimeTypeAdapter
    extends TypeAdapter<LocalDateTime> {
        LocalDateTimeTypeAdapter() {
        }

        public void write(JsonWriter out, LocalDateTime value) throws IOException {
            out.value(value.toString());
        }

        public LocalDateTime read(JsonReader in) throws IOException {
            return LocalDateTime.parse(in.nextString());
        }
    }

    class LocalDateTypeAdapter
    extends TypeAdapter<LocalDate> {
        LocalDateTypeAdapter() {
        }

        public void write(JsonWriter out, LocalDate value) throws IOException {
            out.value(value.toString());
        }

        public LocalDate read(JsonReader in) throws IOException {
            return LocalDate.parse(in.nextString());
        }
    }
}

