/*
 * Decompiled with CFR 0.152.
 */
package com.mailersend.sdk.sms.inboundroutes;

import com.mailersend.sdk.MailerSend;
import com.mailersend.sdk.MailerSendApi;
import com.mailersend.sdk.MailerSendResponse;
import com.mailersend.sdk.exceptions.MailerSendException;
import com.mailersend.sdk.sms.inboundroutes.SingleSmsInboundRouteResponse;
import com.mailersend.sdk.sms.inboundroutes.SmsInboundRoute;
import com.mailersend.sdk.sms.inboundroutes.SmsInboundRouteBuilder;
import com.mailersend.sdk.sms.inboundroutes.SmsInboundRouteList;
import java.util.ArrayList;
import java.util.stream.IntStream;

public class SmsInboundRoutes {
    private MailerSend apiObjectReference;
    private SmsInboundRouteBuilder builder;
    private int pageFilter = 1;
    private int limitFilter = 25;
    private String smsNumberIdFilter;
    private Boolean enabledFilter = null;

    public SmsInboundRoutes(MailerSend ref) {
        this.apiObjectReference = ref;
        this.builder = new SmsInboundRouteBuilder(ref);
    }

    public SmsInboundRouteBuilder builder() {
        return this.builder;
    }

    public SmsInboundRouteBuilder newBuilder() {
        return new SmsInboundRouteBuilder(this.apiObjectReference);
    }

    public SmsInboundRoutes page(int page) {
        this.pageFilter = page;
        return this;
    }

    public SmsInboundRoutes limit(int limit) {
        this.limitFilter = limit;
        return this;
    }

    public SmsInboundRoutes smsNumberId(String smsNumberId) {
        this.smsNumberIdFilter = smsNumberId;
        return this;
    }

    public SmsInboundRoutes enabled(boolean enabled) {
        this.enabledFilter = enabled;
        return this;
    }

    public SmsInboundRouteList getSmsInboundRoutes() throws MailerSendException {
        String endpoint = "/sms-inbounds".concat(this.prepareParamsUrl());
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        SmsInboundRouteList response = api.getRequest(endpoint, SmsInboundRouteList.class);
        response.postDeserialize();
        return response;
    }

    public SmsInboundRoute getSmsInboundRoute(String routeId) throws MailerSendException {
        String endpoint = "/sms-inbounds/".concat(routeId);
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        SingleSmsInboundRouteResponse response = api.getRequest(endpoint, SingleSmsInboundRouteResponse.class);
        response.route.postDeserialize();
        return response.route;
    }

    public boolean deleteSmsInboundRoute(String routeId) throws MailerSendException {
        String endpoint = "/sms-inbounds/".concat(routeId);
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        MailerSendResponse response = api.deleteRequest(endpoint, MailerSendResponse.class);
        return IntStream.of(200, 204, 202).anyMatch(x -> x == response.responseStatusCode);
    }

    private String prepareParamsUrl() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("page=".concat(String.valueOf(this.pageFilter)));
        params.add("limit=".concat(String.valueOf(this.limitFilter)));
        if (this.smsNumberIdFilter != null) {
            params.add("sms_numnber_id=".concat(this.smsNumberIdFilter));
        }
        if (this.enabledFilter != null) {
            params.add("enabled=".concat(String.valueOf(this.enabledFilter)));
        }
        String requestParams = "";
        for (int i = 0; i < params.size(); ++i) {
            String attrSep = "&";
            if (i == 0) {
                attrSep = "?";
            }
            requestParams = requestParams.concat(attrSep).concat((String)params.get(i));
        }
        return requestParams;
    }
}

