/*
 * Decompiled with CFR 0.152.
 */
package com.mailersend.sms.webhooks;

import com.mailersend.sdk.MailerSend;
import com.mailersend.sdk.MailerSendApi;
import com.mailersend.sdk.MailerSendResponse;
import com.mailersend.sdk.exceptions.MailerSendException;
import com.mailersend.sms.webhooks.SingleSmsWebhookResponse;
import com.mailersend.sms.webhooks.SmsWebhook;
import com.mailersend.sms.webhooks.SmsWebhookList;
import com.mailersend.sms.webhooks.SmsWebhooksBuilder;
import java.util.ArrayList;
import java.util.stream.IntStream;

public class SmsWebhooks {
    private MailerSend apiObjectReference;
    private SmsWebhooksBuilder webhooksBuilder;
    private int pageFilter = 1;
    private int limitFilter = 25;

    public SmsWebhooks(MailerSend apiObjectRef) {
        this.apiObjectReference = apiObjectRef;
        this.webhooksBuilder = new SmsWebhooksBuilder(apiObjectRef);
    }

    public SmsWebhooks page(int page) {
        this.pageFilter = page;
        return this;
    }

    public SmsWebhooks limit(int limit) {
        this.limitFilter = limit;
        return this;
    }

    public SmsWebhookList getWebhooks(String smsNumberId) throws MailerSendException {
        String endpoint = "/sms-webhooks".concat(this.prepareParamsUrl(smsNumberId));
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        SmsWebhookList response = api.getRequest(endpoint, SmsWebhookList.class);
        response.postDeserialize();
        return response;
    }

    public SmsWebhook getWebhook(String webhookId) throws MailerSendException {
        String endpoint = "/sms-webhooks/".concat(webhookId);
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        SingleSmsWebhookResponse response = api.getRequest(endpoint, SingleSmsWebhookResponse.class);
        response.webhook.postDeserialize();
        return response.webhook;
    }

    public boolean deleteWebhook(String webhookId) throws MailerSendException {
        String endpoint = "/sms-webhooks/".concat(webhookId);
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        MailerSendResponse response = api.deleteRequest(endpoint, MailerSendResponse.class);
        return IntStream.of(200, 204, 202).anyMatch(x -> x == response.responseStatusCode);
    }

    public SmsWebhooksBuilder builder() {
        return this.webhooksBuilder;
    }

    public SmsWebhooksBuilder newBuilder() {
        return new SmsWebhooksBuilder(this.apiObjectReference);
    }

    private String prepareParamsUrl(String smsNumberId) {
        ArrayList<String> params = new ArrayList<String>();
        params.add("page=".concat(String.valueOf(this.pageFilter)));
        params.add("limit=".concat(String.valueOf(this.limitFilter)));
        params.add("sms_number_id=".concat(smsNumberId));
        String requestParams = "";
        for (int i = 0; i < params.size(); ++i) {
            String attrSep = "&";
            if (i == 0) {
                attrSep = "?";
            }
            requestParams = requestParams.concat(attrSep).concat((String)params.get(i));
        }
        return requestParams;
    }
}

