/*
 * Decompiled with CFR 0.152.
 */
package com.mailersend.sdk.sms.activities;

import com.mailersend.sdk.MailerSend;
import com.mailersend.sdk.MailerSendApi;
import com.mailersend.sdk.exceptions.MailerSendException;
import com.mailersend.sdk.sms.activities.SingleSmsMessageActivityResponse;
import com.mailersend.sdk.sms.activities.SmsActivityList;
import com.mailersend.sdk.sms.activities.SmsMessageActivity;
import java.util.ArrayList;
import java.util.Date;

public class SmsActivities {
    private MailerSend apiObjectReference;
    private int pageFilter = 1;
    private int limitFilter = 25;
    public ArrayList<String> statusFilter = new ArrayList();
    public String numberIdFilter;
    public Date dateFromFilter;
    public Date dateToFilter;

    public SmsActivities(MailerSend ref) {
        this.apiObjectReference = ref;
    }

    public SmsActivities page(int page) {
        this.pageFilter = page;
        return this;
    }

    public SmsActivities limit(int limit) {
        this.limitFilter = limit;
        return this;
    }

    public SmsActivities addStatusFilter(String status) {
        this.statusFilter.add(status);
        return this;
    }

    public SmsActivities clearStatusFilter() {
        this.statusFilter.clear();
        return this;
    }

    public SmsActivities smsNumberId(String numberId) {
        this.numberIdFilter = numberId;
        return this;
    }

    public SmsActivities dateFrom(Date from) {
        this.dateFromFilter = from;
        return this;
    }

    public SmsActivities dateTo(Date to) {
        this.dateToFilter = to;
        return this;
    }

    public SmsActivityList getActivities() throws MailerSendException {
        String endpoint = "/sms-activity".concat(this.prepareParamsUrl());
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        SmsActivityList response = api.getRequest(endpoint, SmsActivityList.class);
        response.postDeserialize();
        return response;
    }

    public SmsMessageActivity getMessageActivity(String messageId) throws MailerSendException {
        String endpoint = "/sms-activity/".concat(messageId);
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        SingleSmsMessageActivityResponse response = api.getRequest(endpoint, SingleSmsMessageActivityResponse.class);
        response.activity.postDeserialize();
        return response.activity;
    }

    private String prepareParamsUrl() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("page=".concat(String.valueOf(this.pageFilter)));
        params.add("limit=".concat(String.valueOf(this.limitFilter)));
        if (this.statusFilter.size() > 0) {
            for (String f : this.statusFilter) {
                params.add("status[]=".concat(f));
            }
        }
        if (this.numberIdFilter != null) {
            params.add("sms_number_id=".concat(this.numberIdFilter));
        }
        if (this.dateFromFilter != null) {
            params.add("date_from=".concat(String.valueOf(this.dateFromFilter.getTime() / 1000L)));
        }
        if (this.dateToFilter != null) {
            params.add("date_to=".concat(String.valueOf(this.dateToFilter.getTime() / 1000L)));
        }
        String requestParams = "";
        for (int i = 0; i < params.size(); ++i) {
            String attrSep = "&";
            if (i == 0) {
                attrSep = "?";
            }
            requestParams = requestParams.concat(attrSep).concat((String)params.get(i));
        }
        return requestParams;
    }
}

