/*
 * Decompiled with CFR 0.152.
 */
package com.mailersend.sdk.sms.activities;

import com.google.gson.annotations.SerializedName;
import com.mailersend.sdk.sms.SmsInfo;
import com.mailersend.sdk.sms.activities.SmsActivity;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;

public class SmsMessageActivity {
    @SerializedName(value="id")
    public String id;
    @SerializedName(value="from")
    public String from;
    @SerializedName(value="to")
    public String[] to;
    @SerializedName(value="text")
    public String text;
    @SerializedName(value="created_at")
    private String createdAtStr;
    public Date createdAt;
    @SerializedName(value="sms")
    public SmsInfo[] sms;
    @SerializedName(value="sms_activity")
    public SmsActivity[] smsActivity;

    public void postDeserialize() {
        if (this.createdAtStr != null && !this.createdAtStr.isBlank()) {
            TemporalAccessor ta = DateTimeFormatter.ISO_INSTANT.parse(this.createdAtStr);
            Instant instant = Instant.from(ta);
            this.createdAt = Date.from(instant);
        }
        for (SmsActivity a : this.smsActivity) {
            a.postDeserialize();
        }
        for (SmsInfo s : this.sms) {
            s.postDeserialize();
        }
    }
}

