/*
 * Decompiled with CFR 0.152.
 */
package com.mailersend.sdk.sms.messages;

import com.mailersend.sdk.MailerSend;
import com.mailersend.sdk.MailerSendApi;
import com.mailersend.sdk.exceptions.MailerSendException;
import com.mailersend.sdk.sms.messages.SingleSmsMessageResponse;
import com.mailersend.sdk.sms.messages.SmsMessage;
import com.mailersend.sdk.sms.messages.SmsMessageList;
import java.util.ArrayList;

public class SmsMessages {
    private MailerSend apiObjectReference;
    private int pageFilter = 1;
    private int limitFilter = 25;

    public SmsMessages(MailerSend ref) {
        this.apiObjectReference = ref;
    }

    public SmsMessages page(int page) {
        this.pageFilter = page;
        return this;
    }

    public SmsMessages limit(int limit) {
        this.limitFilter = limit;
        return this;
    }

    public SmsMessageList getMessages() throws MailerSendException {
        String endpoint = "/sms-messages".concat(this.prepareParamsUrl());
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        SmsMessageList response = api.getRequest(endpoint, SmsMessageList.class);
        response.postDeserialize();
        return response;
    }

    public SmsMessage getMessage(String messageId) throws MailerSendException {
        String endpoint = "/sms-messages/".concat(messageId);
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        SingleSmsMessageResponse response = api.getRequest(endpoint, SingleSmsMessageResponse.class);
        response.message.postDeserialize();
        return response.message;
    }

    private String prepareParamsUrl() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("page=".concat(String.valueOf(this.pageFilter)));
        params.add("limit=".concat(String.valueOf(this.limitFilter)));
        String requestParams = "";
        for (int i = 0; i < params.size(); ++i) {
            String attrSep = "&";
            if (i == 0) {
                attrSep = "?";
            }
            requestParams = requestParams.concat(attrSep).concat((String)params.get(i));
        }
        return requestParams;
    }
}

