/*
 * Decompiled with CFR 0.152.
 */
package com.mailersend.sdk.tokens;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mailersend.sdk.MailerSend;
import com.mailersend.sdk.MailerSendApi;
import com.mailersend.sdk.exceptions.MailerSendException;
import com.mailersend.sdk.tokens.TokenAdd;
import com.mailersend.sdk.tokens.TokenAddRequestBody;
import com.mailersend.sdk.tokens.TokenAddResponse;
import com.mailersend.sdk.util.JsonSerializationDeserializationStrategy;
import java.util.Arrays;

public class TokenAddBuilder {
    private MailerSend apiObjectReference;
    private TokenAddRequestBody tokenAddBody;
    private final String[] scopes = new String[]{"email_full", "domains_read", "domains_full", "activity_read", "activity_full", "analytics_read", "analytics_full", "tokens_full", "webhooks_full", "templates_full"};

    protected TokenAddBuilder(MailerSend apiObjectRef) {
        this.apiObjectReference = apiObjectRef;
        this.tokenAddBody = new TokenAddRequestBody();
    }

    public TokenAddBuilder name(String name) {
        this.tokenAddBody.name = name;
        return this;
    }

    public TokenAddBuilder domainId(String domainId) {
        this.tokenAddBody.domainId = domainId;
        return this;
    }

    public TokenAddBuilder addScope(String scope) throws MailerSendException {
        if (!Arrays.asList(this.scopes).contains(scope)) {
            throw new MailerSendException("Scope is not valid");
        }
        this.tokenAddBody.scopes.add(scope);
        return this;
    }

    public TokenAdd addToken() throws MailerSendException {
        if (this.tokenAddBody.name == null || this.tokenAddBody.name.isBlank()) {
            throw new MailerSendException("Token name cannot be null or empty");
        }
        if (this.tokenAddBody.domainId == null || this.tokenAddBody.domainId.isBlank()) {
            throw new MailerSendException("Domain ID cannot be null or empty");
        }
        if (this.tokenAddBody.scopes.size() == 0) {
            throw new MailerSendException("At least one scope is required");
        }
        String endpoint = "/token";
        MailerSendApi api = new MailerSendApi();
        api.setToken(this.apiObjectReference.getToken());
        Gson gson = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new JsonSerializationDeserializationStrategy(false)).addDeserializationExclusionStrategy((ExclusionStrategy)new JsonSerializationDeserializationStrategy(true)).create();
        String json = gson.toJson((Object)this.tokenAddBody);
        this.tokenAddBody.reset();
        TokenAddResponse response = api.postRequest(endpoint, json, TokenAddResponse.class);
        response.tokenAdd.postDeserialize();
        return response.tokenAdd;
    }
}

