/*
 * Decompiled with CFR 0.152.
 */
package com.mazepeng.codec;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class BencodeDecoder {
    private final PushbackInputStream in;
    private static final int MAX_BYTE_STRING_LENGTH = 0x800000;

    private BencodeDecoder(InputStream in) {
        this.in = new PushbackInputStream(in);
    }

    public static Object decode(InputStream in) throws IOException {
        return new BencodeDecoder(in).decodeNext();
    }

    private Object decodeNext() throws IOException {
        int firstByte = this.in.read();
        switch (firstByte) {
            case -1: {
                throw new EOFException("Bencode stream ended unexpectedly.");
            }
            case 105: {
                return this.decodeInteger();
            }
            case 108: {
                return this.decodeList();
            }
            case 100: {
                return this.decodeDictionary();
            }
            case 101: {
                throw new IOException("Unexpected 'e' marker at this position.");
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.in.unread(firstByte);
                return this.decodeBytes();
            }
        }
        throw new IOException("Unknown Bencode type prefix: '" + (char)firstByte + "'");
    }

    private Long decodeInteger() throws IOException {
        int currentByte;
        StringBuilder sb = new StringBuilder();
        while ((currentByte = this.in.read()) != 101) {
            if (currentByte == -1) {
                throw new EOFException("Unterminated Bencoded integer.");
            }
            sb.append((char)currentByte);
        }
        try {
            return Long.parseLong(sb.toString());
        }
        catch (NumberFormatException e) {
            throw new IOException("Invalid integer format: " + sb, e);
        }
    }

    private byte[] decodeBytes() throws IOException {
        int readResult;
        long length = this.readLength();
        if (length < 0L) {
            throw new IOException("Byte string length cannot be negative: " + length);
        }
        if (length > 0x800000L) {
            throw new IOException("Byte string length exceeds safety limit: " + length);
        }
        int intLength = (int)length;
        byte[] bytes = new byte[intLength];
        for (int bytesRead = 0; bytesRead < intLength; bytesRead += readResult) {
            readResult = this.in.read(bytes, bytesRead, intLength - bytesRead);
            if (readResult != -1) continue;
            throw new EOFException("Unexpected end of stream while reading byte string. Expected " + intLength + " bytes, but only got " + bytesRead);
        }
        return bytes;
    }

    private long readLength() throws IOException {
        int currentByte;
        StringBuilder sb = new StringBuilder();
        while ((currentByte = this.in.read()) != 58) {
            if (currentByte == -1) {
                throw new EOFException("Unterminated byte string length.");
            }
            if (currentByte < 48 || currentByte > 57) {
                throw new IOException("Invalid character in byte string length: '" + (char)currentByte + "'");
            }
            sb.append((char)currentByte);
        }
        return Long.parseLong(sb.toString());
    }

    private List<Object> decodeList() throws IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        while (true) {
            int peekByte;
            if ((peekByte = this.in.read()) == -1) {
                throw new EOFException("Unterminated Bencoded list.");
            }
            if (peekByte == 101) break;
            this.in.unread(peekByte);
            list.add(this.decodeNext());
        }
        return list;
    }

    private Map<String, Object> decodeDictionary() throws IOException {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        while (true) {
            int peekByte;
            if ((peekByte = this.in.read()) == -1) {
                throw new EOFException("Unterminated Bencoded dictionary.");
            }
            if (peekByte == 101) break;
            this.in.unread(peekByte);
            Object keyObj = this.decodeNext();
            if (!(keyObj instanceof byte[])) {
                throw new IOException("Dictionary key must be a byte string, but got " + keyObj.getClass().getSimpleName());
            }
            String key = new String((byte[])keyObj, StandardCharsets.UTF_8);
            Object value = this.decodeNext();
            map.put(key, value);
        }
        return map;
    }
}

