/*
 * Decompiled with CFR 0.152.
 */
package com.mazepeng.codec;

import com.mazepeng.codec.IntegerUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class BencodeEncoder {
    private static final byte INTEGER_PREFIX = 105;
    private static final byte LIST_PREFIX = 108;
    private static final byte DICTIONARY_PREFIX = 100;
    private static final byte END_SUFFIX = 101;
    private static final byte SEPARATOR = 58;
    private static final ThreadLocal<byte[]> NUMBER_BUFFER = ThreadLocal.withInitial(() -> new byte[21]);

    public static void encode(Object obj, OutputStream out) throws IOException {
        if (obj instanceof String) {
            BencodeEncoder.encode((String)obj, out);
        } else if (obj instanceof byte[]) {
            BencodeEncoder.encode((byte[])obj, out);
        } else if (obj instanceof Number) {
            BencodeEncoder.encode(((Number)obj).longValue(), out);
        } else if (obj instanceof List) {
            BencodeEncoder.encode((List)obj, out);
        } else if (obj instanceof Map) {
            if (obj instanceof TreeMap) {
                BencodeEncoder.encode((Map)obj, out);
            } else {
                BencodeEncoder.encode(new TreeMap((Map)obj), out);
            }
        } else {
            throw new IllegalArgumentException("Unsupported type for Bencode encoding: " + obj.getClass());
        }
    }

    public static void encode(String str, OutputStream out) throws IOException {
        BencodeEncoder.encode(str.getBytes(StandardCharsets.UTF_8), out);
    }

    public static void encode(byte[] bytes, OutputStream out) throws IOException {
        byte[] buffer = NUMBER_BUFFER.get();
        int len = IntegerUtils.longToBytes(bytes.length, buffer, 0);
        out.write(buffer, 0, len);
        out.write(58);
        out.write(bytes);
    }

    public static void encode(long value, OutputStream out) throws IOException {
        out.write(105);
        byte[] buffer = NUMBER_BUFFER.get();
        int len = IntegerUtils.longToBytes(value, buffer, 0);
        out.write(buffer, 0, len);
        out.write(101);
    }

    public static void encode(List<?> list, OutputStream out) throws IOException {
        out.write(108);
        for (Object item : list) {
            BencodeEncoder.encode(item, out);
        }
        out.write(101);
    }

    public static void encode(Map<String, ?> map, OutputStream out) throws IOException {
        out.write(100);
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            BencodeEncoder.encode(entry.getKey(), out);
            BencodeEncoder.encode(entry.getValue(), out);
        }
        out.write(101);
    }
}

