/*
 * Decompiled with CFR 0.152.
 */
package com.mazepeng.codec;

import com.mazepeng.codec.BencodeDecoder;
import com.mazepeng.codec.BencodeEncoder;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class DebugExample {
    public static void main(String[] args) throws IOException {
        String torrentFilePath = "/";
        try {
            Object decodedObject;
            System.out.println("--- \u5f00\u59cb\u6d4b\u8bd5\u79cd\u5b50\u6587\u4ef6: " + torrentFilePath + " ---\n");
            Path path = Paths.get(torrentFilePath, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                System.err.println("\u9519\u8bef: \u79cd\u5b50\u6587\u4ef6\u672a\u627e\u5230\uff0c\u8bf7\u68c0\u67e5\u8def\u5f84: " + path.toAbsolutePath());
                return;
            }
            byte[] originalBytes = Files.readAllBytes(path);
            System.out.println("\u539f\u59cb\u6587\u4ef6\u5927\u5c0f: " + originalBytes.length + " bytes");
            System.out.println("\n--- \u6b65\u9aa4 1: \u89e3\u7801 ---");
            try (FileInputStream in = new FileInputStream(torrentFilePath);){
                decodedObject = BencodeDecoder.decode(in);
            }
            System.out.println("\u89e3\u7801\u6210\u529f\uff01\u89e3\u7801\u51fa\u7684\u5bf9\u8c61\u7c7b\u578b: " + decodedObject.getClass().getSimpleName());
            System.out.println("\n--- \u6b65\u9aa4 2: \u7f8e\u5316\u6253\u5370\u89e3\u7801\u5185\u5bb9 ---");
            System.out.println(DebugExample.prettyPrint(decodedObject, 0));
            System.out.println("\n--- \u6b65\u9aa4 3: \u91cd\u65b0\u7f16\u7801 ---");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BencodeEncoder.encode(decodedObject, (OutputStream)baos);
            byte[] reEncodedBytes = baos.toByteArray();
            System.out.println("\u91cd\u65b0\u7f16\u7801\u6210\u529f\uff01\u7f16\u7801\u540e\u5927\u5c0f: " + reEncodedBytes.length + " bytes");
            System.out.println("\n--- \u6b65\u9aa4 4: \u9a8c\u8bc1\u4e00\u81f4\u6027 ---");
            if (Arrays.equals(originalBytes, reEncodedBytes)) {
                System.out.println("\u6210\u529f: \u91cd\u65b0\u7f16\u7801\u540e\u7684\u5b57\u8282\u4e0e\u539f\u59cb\u6587\u4ef6\u5b8c\u5168\u4e00\u81f4\uff01\u7f16\u7801\u5668\u548c\u89e3\u7801\u5668\u5de5\u4f5c\u6b63\u5e38\u3002");
            } else {
                System.err.println("\u5931\u8d25: \u91cd\u65b0\u7f16\u7801\u540e\u7684\u5b57\u8282\u4e0e\u539f\u59cb\u6587\u4ef6\u4e0d\u4e00\u81f4\uff01");
            }
        }
        catch (IOException e) {
            System.err.println("\n\u5904\u7406\u8fc7\u7a0b\u4e2d\u53d1\u751fIO\u5f02\u5e38:");
            e.printStackTrace();
        }
        catch (Exception e) {
            System.err.println("\n\u5904\u7406\u8fc7\u7a0b\u4e2d\u53d1\u751f\u672a\u77e5\u5f02\u5e38:");
            e.printStackTrace();
        }
    }

    public static String prettyPrint(Object obj, int indentLevel) {
        StringBuilder indent = new StringBuilder();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append("  ");
        }
        if (obj instanceof Map) {
            StringBuilder sb = new StringBuilder("{\n");
            Map map = (Map)obj;
            for (Map.Entry entry : map.entrySet()) {
                sb.append((CharSequence)indent).append("  \"").append((String)entry.getKey()).append("\": ");
                sb.append(DebugExample.prettyPrint(entry.getValue(), indentLevel + 1));
                sb.append(",\n");
            }
            if (!map.isEmpty()) {
                sb.setLength(sb.length() - 2);
            }
            sb.append("\n").append((CharSequence)indent).append("}");
            return sb.toString();
        }
        if (obj instanceof List) {
            StringBuilder sb = new StringBuilder("[\n");
            List list = (List)obj;
            for (Object item : list) {
                sb.append((CharSequence)indent).append("  ").append(DebugExample.prettyPrint(item, indentLevel + 1));
                sb.append(",\n");
            }
            if (!list.isEmpty()) {
                sb.setLength(sb.length() - 2);
            }
            sb.append("\n").append((CharSequence)indent).append("]");
            return sb.toString();
        }
        if (obj instanceof Long) {
            return obj.toString();
        }
        if (obj instanceof byte[]) {
            byte[] bytes = (byte[])obj;
            try {
                for (byte b : bytes) {
                    if (b >= 32 || b == 10 || b == 13 || b == 9) continue;
                    return "\"<binary " + bytes.length + " bytes>\"";
                }
                return "\"" + new String(bytes, StandardCharsets.UTF_8) + "\"";
            }
            catch (Exception e) {
                return "\"<binary " + bytes.length + " bytes>\"";
            }
        }
        return "null";
    }
}

